/*
 * Decompiled with CFR 0.152.
 */
package brave.rpc;

import brave.SpanCustomizer;
import brave.Tags;
import brave.propagation.TraceContext;
import brave.rpc.RpcResponse;
import brave.rpc.RpcTags;

public interface RpcResponseParser {
    public static final RpcResponseParser DEFAULT = new Default();

    public void parse(RpcResponse var1, TraceContext var2, SpanCustomizer var3);

    public static class Default
    implements RpcResponseParser {
        @Override
        public void parse(RpcResponse response, TraceContext context, SpanCustomizer span) {
            String errorCode = response.errorCode();
            if (errorCode != null) {
                span.tag(RpcTags.ERROR_CODE.key(), errorCode);
                if (response.error() == null) {
                    span.tag(Tags.ERROR.key(), errorCode);
                }
            }
        }
    }
}

