/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock.runtime;

import java.util.Arrays;
import java.util.List;
import org.spockframework.mock.IMockConfiguration;
import org.spockframework.mock.IMockFactory;
import org.spockframework.mock.runtime.GroovyMockFactory;
import org.spockframework.mock.runtime.JavaMockFactory;
import org.spockframework.util.InternalSpockError;
import org.spockframework.util.UnreachableCodeError;
import spock.lang.Specification;

public class CompositeMockFactory
implements IMockFactory {
    public static final CompositeMockFactory INSTANCE = new CompositeMockFactory(Arrays.asList(JavaMockFactory.INSTANCE, GroovyMockFactory.INSTANCE));
    private final List<IMockFactory> mockFactories;

    public CompositeMockFactory(List<IMockFactory> mockFactories) {
        this.mockFactories = mockFactories;
    }

    @Override
    public boolean canCreate(IMockConfiguration configuration) {
        throw new UnreachableCodeError("canCreate");
    }

    @Override
    public Object create(IMockConfiguration configuration, Specification specification) {
        for (IMockFactory factory : this.mockFactories) {
            if (!factory.canCreate(configuration)) continue;
            return factory.create(configuration, specification);
        }
        throw new InternalSpockError("No matching mock factory found");
    }

    @Override
    public Object createDetached(IMockConfiguration configuration, ClassLoader classLoader) {
        for (IMockFactory factory : this.mockFactories) {
            if (!factory.canCreate(configuration)) continue;
            return factory.createDetached(configuration, classLoader);
        }
        throw new InternalSpockError("No matching mock factory found");
    }
}

