/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock.runtime;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.spockframework.mock.CannotCreateMockException;
import org.spockframework.mock.IMockConfiguration;
import org.spockframework.mock.IMockFactory;
import org.spockframework.mock.MockImplementation;
import org.spockframework.mock.MockNature;
import org.spockframework.mock.runtime.GroovyMockInterceptor;
import org.spockframework.mock.runtime.GroovyMockMetaClass;
import org.spockframework.mock.runtime.MockInstantiator;
import org.spockframework.mock.runtime.ProxyBasedMockFactory;
import org.spockframework.runtime.GroovyRuntimeUtil;
import org.spockframework.util.ReflectionUtil;
import spock.lang.Specification;

public class GroovyMockFactory
implements IMockFactory {
    public static final GroovyMockFactory INSTANCE = new GroovyMockFactory();

    @Override
    public boolean canCreate(IMockConfiguration configuration) {
        return configuration.getImplementation() == MockImplementation.GROOVY;
    }

    @Override
    public Object create(IMockConfiguration configuration, Specification specification) throws CannotCreateMockException {
        MetaClass oldMetaClass = GroovyRuntimeUtil.getMetaClass(configuration.getType());
        GroovyMockMetaClass newMetaClass = new GroovyMockMetaClass(configuration, specification, oldMetaClass);
        Class<?> type = configuration.getType();
        if (configuration.isGlobal()) {
            if (type.isInterface()) {
                throw new CannotCreateMockException(type, ". Global mocking is only possible for classes, but not for interfaces.");
            }
            if (!configuration.getAdditionalInterfaces().isEmpty()) {
                throw new CannotCreateMockException(type, ". Global cannot add additionalInterfaces.");
            }
            GroovyRuntimeUtil.setMetaClass(type, (MetaClass)newMetaClass);
            specification.getSpecificationContext().getCurrentIteration().addCleanup(() -> GroovyRuntimeUtil.setMetaClass(type, oldMetaClass));
            return MockInstantiator.instantiate(type, type, configuration.getConstructorArgs(), configuration.isUseObjenesis());
        }
        if (this.isFinalClass(type)) {
            if (!configuration.getAdditionalInterfaces().isEmpty()) {
                throw new CannotCreateMockException(type, ". Cannot add additionalInterfaces to final classes.");
            }
            Object instance = MockInstantiator.instantiate(type, type, configuration.getConstructorArgs(), configuration.isUseObjenesis());
            GroovyRuntimeUtil.setMetaClass(instance, (MetaClass)newMetaClass);
            return instance;
        }
        GroovyMockInterceptor mockInterceptor = new GroovyMockInterceptor(configuration, specification, (MetaClass)newMetaClass);
        ArrayList additionalInterfaces = new ArrayList(configuration.getAdditionalInterfaces());
        additionalInterfaces.add(GroovyObject.class);
        Object proxy = ProxyBasedMockFactory.INSTANCE.create(type, additionalInterfaces, configuration.getConstructorArgs(), mockInterceptor, specification.getClass().getClassLoader(), configuration.isUseObjenesis());
        if (configuration.getNature() == MockNature.SPY && configuration.getInstance() != null) {
            ReflectionUtil.deepCopyFields(configuration.getInstance(), proxy);
        }
        return proxy;
    }

    private boolean isFinalClass(Class<?> type) {
        return !type.isInterface() && Modifier.isFinal(type.getModifiers());
    }

    @Override
    public Object createDetached(IMockConfiguration configuration, ClassLoader classLoader) {
        throw new CannotCreateMockException(configuration.getType(), ". Detached mocking is only possible for JavaMocks but not GroovyMocks at the moment.");
    }
}

