/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;
import org.spockframework.runtime.ExpressionComparisonRenderer;
import org.spockframework.runtime.FailedEqualityComparisonRenderer;
import org.spockframework.runtime.FailedInstanceOfComparisonRenderer;
import org.spockframework.runtime.FailedSetEqualityComparisonRenderer;
import org.spockframework.runtime.FailedStringComparisonRenderer;
import org.spockframework.runtime.IMethodNameMapper;
import org.spockframework.runtime.StackTraceFilter;
import org.spockframework.runtime.model.ExpressionInfo;
import org.spockframework.util.RenderUtil;

public class ExpressionInfoValueRenderer {
    private static final List<ExpressionComparisonRenderer> RENDERERS = Arrays.asList(new FailedStringComparisonRenderer(), new FailedSetEqualityComparisonRenderer(), new FailedEqualityComparisonRenderer(), new FailedInstanceOfComparisonRenderer());
    private static final StackTraceFilter genericStackTraceFilter = new StackTraceFilter(new IMethodNameMapper(){

        @Override
        public boolean isInitializerOrFixtureMethod(String className, String methodName) {
            return false;
        }

        @Override
        public String toFeatureName(String methodName) {
            return methodName;
        }
    });
    private final ExpressionInfo expr;

    private ExpressionInfoValueRenderer(ExpressionInfo expr) {
        this.expr = expr;
    }

    public static void render(ExpressionInfo expr) {
        new ExpressionInfoValueRenderer(expr).render();
    }

    private void render() {
        for (ExpressionInfo expr : this.expr.inPostfixOrder(true)) {
            expr.setRenderedValue(ExpressionInfoValueRenderer.renderValue(expr));
        }
    }

    static String renderValue(ExpressionInfo expr) {
        int index;
        String text;
        String potentialEnumConstantNameInText;
        String str;
        Object value = expr.getValue();
        if (value == null) {
            return "null";
        }
        if ("".equals(value)) {
            return "\"\"";
        }
        try {
            str = ExpressionInfoValueRenderer.doRenderValue(expr);
        }
        catch (Exception e) {
            return String.format("%s (renderer threw %s)", ExpressionInfoValueRenderer.javaLangObjectToString(value), e.getClass().getSimpleName());
        }
        if (value instanceof Throwable) {
            Throwable throwable = (Throwable)value;
            genericStackTraceFilter.filter(throwable);
            StringWriter stackTrace = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stackTrace));
            return stackTrace.toString();
        }
        if (str == null || "".equals(str)) {
            return ExpressionInfoValueRenderer.javaLangObjectToString(value);
        }
        if (value instanceof Enum && str.equals(potentialEnumConstantNameInText = (text = expr.getText().trim()).substring((index = text.lastIndexOf(46)) + 1))) {
            return null;
        }
        return str;
    }

    private static String javaLangObjectToString(Object value) {
        String hash = Integer.toHexString(System.identityHashCode(value));
        Class<?> type = value.getClass();
        String typeName = type.getCanonicalName();
        return (typeName == null ? type.getName() : typeName) + "@" + hash;
    }

    private static String doRenderValue(ExpressionInfo expr) {
        for (ExpressionComparisonRenderer renderer : RENDERERS) {
            String result = renderer.render(expr);
            if (result == null) continue;
            return result;
        }
        return ExpressionInfoValueRenderer.renderToStringOrDump(expr);
    }

    private static String renderToStringOrDump(ExpressionInfo expr) {
        return RenderUtil.toStringOrDump(expr.getValue());
    }
}

