/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import groovy.lang.Closure;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Map;
import org.spockframework.runtime.GroovyRuntimeUtil;
import org.spockframework.runtime.extension.ExtensionException;
import org.spockframework.runtime.extension.IAnnotationDrivenExtension;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.extension.IMethodInvocation;
import org.spockframework.runtime.extension.builtin.PreconditionContext;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.SpecInfo;

public abstract class ConditionalExtension<T extends Annotation>
implements IAnnotationDrivenExtension<T> {
    protected abstract Class<? extends Closure> getConditionClass(T var1);

    protected void specConditionResult(boolean result, T annotation, SpecInfo spec) {
        throw new UnsupportedOperationException();
    }

    protected void sharedConditionResult(boolean result, T annotation, IMethodInvocation invocation) throws Throwable {
        this.iterationConditionResult(result, annotation, invocation);
    }

    protected void featureConditionResult(boolean result, T annotation, FeatureInfo feature) {
        throw new UnsupportedOperationException();
    }

    protected void iterationConditionResult(boolean result, T annotation, IMethodInvocation invocation) throws Throwable {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitSpecAnnotation(T annotation, SpecInfo spec) {
        Closure condition = this.createCondition(annotation);
        try {
            Object result = ConditionalExtension.evaluateCondition(condition, spec.getReflection());
            this.specConditionResult(GroovyRuntimeUtil.isTruthy(result), annotation, spec);
        }
        catch (ExtensionException ee) {
            if (ee.getCause() instanceof PreconditionContext.SharedContextException) {
                spec.addSetupSpecInterceptor(new SharedCondition(this, condition, annotation));
            }
            if (ee.getCause() instanceof PreconditionContext.InstanceContextException) {
                IterationCondition interceptor = new IterationCondition(this, condition, annotation);
                spec.getAllFeatures().forEach(featureInfo -> featureInfo.addIterationInterceptor(interceptor));
            }
            throw ee;
        }
    }

    @Override
    public void visitFeatureAnnotation(T annotation, FeatureInfo feature) {
        if (feature.getSpec().isSkipped()) {
            return;
        }
        Closure condition = this.createCondition(annotation);
        try {
            Object result = ConditionalExtension.evaluateCondition(condition, feature.getSpec().getReflection());
            this.featureConditionResult(GroovyRuntimeUtil.isTruthy(result), annotation, feature);
        }
        catch (ExtensionException ee) {
            if (ee.getCause() instanceof PreconditionContext.PreconditionContextException) {
                if (ee.getCause() instanceof PreconditionContext.DataVariableContextException && !feature.getDataVariables().contains(((PreconditionContext.DataVariableContextException)ee.getCause()).getDataVariable())) {
                    throw ee;
                }
                feature.getFeatureMethod().addInterceptor(new IterationCondition(this, condition, annotation));
            }
            throw ee;
        }
    }

    private Closure createCondition(T annotation) {
        Class<Closure> clazz = this.getConditionClass(annotation);
        try {
            return clazz.getConstructor(Object.class, Object.class).newInstance(null, null);
        }
        catch (Exception e) {
            throw new ExtensionException("Failed to instantiate condition", e);
        }
    }

    private static Object evaluateCondition(Closure condition, Object sharedInstance, Object instance, Map<String, Object> dataVariables) {
        return ConditionalExtension.evaluateCondition(condition, sharedInstance, instance, dataVariables, null);
    }

    private static Object evaluateCondition(Closure condition, Object owner) {
        return ConditionalExtension.evaluateCondition(condition, null, null, Collections.emptyMap(), owner);
    }

    private static Object evaluateCondition(Closure condition, Object sharedInstance, Object instance, Map<String, Object> dataVariables, Object owner) {
        PreconditionContext context = new PreconditionContext(sharedInstance, instance, dataVariables);
        condition = condition.rehydrate((Object)context, owner, null);
        condition.setResolveStrategy(1);
        try {
            return condition.call((Object)context);
        }
        catch (Exception e) {
            throw new ExtensionException("Failed to evaluate condition", e);
        }
    }

    private static class IterationCondition
    extends ConditionInterceptor {
        final /* synthetic */ ConditionalExtension this$0;

        public IterationCondition(Closure condition, T annotation) {
            this.this$0 = var1_1;
            super((ConditionalExtension)var1_1, condition, annotation);
        }

        @Override
        public void intercept(IMethodInvocation invocation) throws Throwable {
            Object result = ConditionalExtension.evaluateCondition(this.condition, invocation.getSharedInstance(), invocation.getInstance(), invocation.getIteration().getDataVariables());
            this.this$0.iterationConditionResult(GroovyRuntimeUtil.isTruthy(result), this.annotation, invocation);
            invocation.proceed();
        }
    }

    private static class SharedCondition
    extends ConditionInterceptor {
        final /* synthetic */ ConditionalExtension this$0;

        public SharedCondition(Closure condition, T annotation) {
            this.this$0 = var1_1;
            super((ConditionalExtension)var1_1, condition, annotation);
        }

        @Override
        public void intercept(IMethodInvocation invocation) throws Throwable {
            try {
                Object result = ConditionalExtension.evaluateCondition(this.condition, invocation.getSharedInstance(), null, Collections.emptyMap());
                this.this$0.sharedConditionResult(GroovyRuntimeUtil.isTruthy(result), this.annotation, invocation);
            }
            catch (ExtensionException ee) {
                if (ee.getCause() instanceof PreconditionContext.InstanceContextException) {
                    IterationCondition interceptor = new IterationCondition(this.this$0, this.condition, this.annotation);
                    invocation.getSpec().getAllFeatures().stream().map(FeatureInfo::getFeatureMethod).forEach(methodInfo -> methodInfo.addInterceptor(interceptor));
                }
                throw ee;
            }
            invocation.proceed();
        }
    }

    private static abstract class ConditionInterceptor
    implements IMethodInterceptor {
        protected final Closure condition;
        protected final T annotation;
        final /* synthetic */ ConditionalExtension this$0;

        public ConditionInterceptor(Closure condition, T annotation) {
            this.this$0 = var1_1;
            this.condition = condition;
            this.annotation = annotation;
        }
    }
}

