/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import java.lang.annotation.Annotation;
import java.util.List;
import org.spockframework.runtime.extension.IGlobalExtension;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.NodeInfo;
import org.spockframework.runtime.model.SpecInfo;
import spock.config.IncludeExcludeCriteria;
import spock.config.RunnerConfiguration;

public class IncludeExcludeExtension
implements IGlobalExtension {
    private final RunnerConfiguration config;

    public IncludeExcludeExtension(RunnerConfiguration config) {
        this.config = config;
    }

    @Override
    public void visitSpec(SpecInfo spec) {
        this.handleSpecIncludes(spec, this.config.include);
        this.handleSpecExcludes(spec, this.config.exclude);
        if (spec.isExcluded()) {
            this.excludeAllFeatures(spec);
        }
        this.handleFeatureIncludes(spec, this.config.include);
        this.handleFeatureExcludes(spec, this.config.exclude);
        if (spec.isExcluded() && !this.allFeaturesExcluded(spec)) {
            spec.setExcluded(false);
        }
    }

    private void handleSpecIncludes(SpecInfo spec, IncludeExcludeCriteria criteria) {
        if (criteria.isEmpty()) {
            return;
        }
        if (!this.hasAnyAnnotation(spec, criteria.annotations) && !this.hasAnyBaseClass(spec, criteria.baseClasses)) {
            spec.setExcluded(true);
        }
    }

    private void handleSpecExcludes(SpecInfo spec, IncludeExcludeCriteria criteria) {
        if (criteria.isEmpty()) {
            return;
        }
        if (this.hasAnyAnnotation(spec, criteria.annotations) || this.hasAnyBaseClass(spec, criteria.baseClasses)) {
            spec.setExcluded(true);
        }
    }

    private void handleFeatureIncludes(SpecInfo spec, IncludeExcludeCriteria criteria) {
        if (criteria.isEmpty()) {
            return;
        }
        for (FeatureInfo feature : spec.getAllFeatures()) {
            if (!this.hasAnyAnnotation(feature.getFeatureMethod(), criteria.annotations)) continue;
            feature.setExcluded(false);
        }
    }

    private void handleFeatureExcludes(SpecInfo spec, IncludeExcludeCriteria criteria) {
        if (criteria.isEmpty()) {
            return;
        }
        for (FeatureInfo feature : spec.getAllFeatures()) {
            if (!this.hasAnyAnnotation(feature.getFeatureMethod(), criteria.annotations)) continue;
            feature.setExcluded(true);
        }
    }

    private void excludeAllFeatures(SpecInfo spec) {
        for (FeatureInfo feature : spec.getAllFeatures()) {
            feature.setExcluded(true);
        }
    }

    private boolean allFeaturesExcluded(SpecInfo spec) {
        for (FeatureInfo feature : spec.getAllFeatures()) {
            if (feature.isExcluded()) continue;
            return false;
        }
        return true;
    }

    private boolean hasAnyAnnotation(NodeInfo<?, ?> node, List<Class<? extends Annotation>> annotationClasses) {
        for (Class<? extends Annotation> annClass : annotationClasses) {
            if (!node.getReflection().isAnnotationPresent(annClass)) continue;
            return true;
        }
        return false;
    }

    private boolean hasAnyBaseClass(SpecInfo spec, List<Class<?>> baseClasses) {
        for (Class<?> clazz : baseClasses) {
            if (!clazz.isAssignableFrom((Class)spec.getReflection())) continue;
            return true;
        }
        return false;
    }
}

