/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import org.spockframework.report.log.ReportLogConfiguration;
import org.spockframework.runtime.extension.IAnnotationDrivenExtension;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.SpecElementInfo;
import org.spockframework.runtime.model.SpecInfo;
import org.spockframework.runtime.model.Tag;
import spock.lang.Issue;

public class IssueExtension
implements IAnnotationDrivenExtension<Issue> {
    private final ReportLogConfiguration configuration;

    public IssueExtension(ReportLogConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void visitSpecAnnotation(Issue issue, SpecInfo spec) {
        this.addTags(issue, spec);
    }

    @Override
    public void visitFeatureAnnotation(Issue issue, FeatureInfo feature) {
        this.addTags(issue, feature);
    }

    private void addTags(Issue issue, SpecElementInfo specElement) {
        for (String value : issue.value()) {
            if (value.startsWith("http")) {
                int index = value.lastIndexOf(47);
                String name = value.substring(index + 1);
                specElement.addTag(new Tag(this.configuration.issueNamePrefix + name, "issue", name, value));
                continue;
            }
            specElement.addTag(new Tag(this.configuration.issueNamePrefix + value, "issue", value, this.configuration.issueUrlPrefix + value));
        }
    }
}

