/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.spockframework.runtime.DataVariablesIterationNameProvider;
import org.spockframework.runtime.GroovyRuntimeUtil;
import org.spockframework.runtime.SpockAssertionError;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.IterationInfo;
import org.spockframework.runtime.model.NameProvider;
import org.spockframework.util.RenderUtil;

public class UnrollIterationNameProvider
implements NameProvider<IterationInfo> {
    private static final Pattern EXPRESSION_PATTERN = Pattern.compile("#([a-zA-Z_$]([\\w$.]|\\(\\))*)");
    private static final DataVariablesIterationNameProvider DATA_VARIABLES = new DataVariablesIterationNameProvider(false, false);
    private static final DataVariablesIterationNameProvider DATA_VARIABLES_WITH_INDEX = new DataVariablesIterationNameProvider(false, true);
    private final boolean validateExpressions;
    private final FeatureInfo feature;
    private final Matcher expressionMatcher;

    public UnrollIterationNameProvider(FeatureInfo feature, String namePattern, boolean validateExpressions) {
        this.feature = feature;
        this.validateExpressions = validateExpressions;
        this.expressionMatcher = EXPRESSION_PATTERN.matcher(namePattern);
    }

    @Override
    public String getName(IterationInfo iterationInfo) {
        return this.nameFor(iterationInfo.getDataVariables(), iterationInfo);
    }

    private String nameFor(Map<String, Object> dataVariables, IterationInfo iterationInfo) {
        StringBuffer result = new StringBuffer();
        this.expressionMatcher.reset();
        while (this.expressionMatcher.find()) {
            String expr = this.expressionMatcher.group(1);
            String value = this.evaluateExpression(expr, dataVariables, iterationInfo);
            this.expressionMatcher.appendReplacement(result, Matcher.quoteReplacement(value));
        }
        this.expressionMatcher.appendTail(result);
        return result.toString();
    }

    private String evaluateExpression(String expr, Map<String, Object> dataVariables, IterationInfo iterationInfo) {
        Object result;
        String firstPart;
        String[] exprParts = expr.split("\\.");
        switch (firstPart = exprParts[0]) {
            case "featureName": {
                result = this.feature.getName();
                break;
            }
            case "iterationIndex": {
                result = String.valueOf(iterationInfo.getIterationIndex());
                break;
            }
            case "dataVariables": {
                result = DATA_VARIABLES.getName(iterationInfo);
                break;
            }
            case "dataVariablesWithIndex": {
                result = DATA_VARIABLES_WITH_INDEX.getName(iterationInfo);
                break;
            }
            default: {
                if (!dataVariables.containsKey(firstPart)) {
                    if (this.validateExpressions) {
                        throw new SpockAssertionError("Error in @Unroll, could not find matching variable for expression: " + expr);
                    }
                    return "#Error:" + expr;
                }
                result = dataVariables.get(firstPart);
            }
        }
        try {
            for (int i = 1; i < exprParts.length; ++i) {
                String currPart = exprParts[i];
                result = currPart.endsWith("()") ? GroovyRuntimeUtil.invokeMethod(result, currPart.substring(0, currPart.length() - 2), new Object[0]) : GroovyRuntimeUtil.getProperty(result, currPart);
            }
            return RenderUtil.toStringOrDump(result);
        }
        catch (Exception e) {
            if (this.validateExpressions) {
                throw new SpockAssertionError("Error in @Unroll expression: " + expr, e);
            }
            return "#Error:" + expr;
        }
    }
}

