/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.model;

import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.INameable;
import org.spockframework.runtime.model.NodeInfo;
import org.spockframework.util.DataVariableMap;

public class IterationInfo
extends NodeInfo<FeatureInfo, AnnotatedElement>
implements INameable {
    private final int iterationIndex;
    private final Object[] dataValues;
    private final int estimatedNumIterations;
    private final List<Runnable> cleanups = new ArrayList<Runnable>();
    private Map<String, Object> dataVariables;
    private String displayName;

    public IterationInfo(FeatureInfo feature, int iterationIndex, Object[] dataValues, int estimatedNumIterations) {
        this.setParent(feature);
        this.iterationIndex = iterationIndex;
        this.dataValues = dataValues;
        this.estimatedNumIterations = estimatedNumIterations;
    }

    public FeatureInfo getFeature() {
        return (FeatureInfo)this.getParent();
    }

    @Override
    public AnnotatedElement getReflection() {
        throw new UnsupportedOperationException("getReflection");
    }

    public int getIterationIndex() {
        return this.iterationIndex;
    }

    public Object[] getDataValues() {
        return this.dataValues;
    }

    public Map<String, Object> getDataVariables() {
        if (this.dataVariables == null) {
            this.dataVariables = new DataVariableMap(this.getFeature().getDataVariables(), this.dataValues);
        }
        return this.dataVariables;
    }

    public int getEstimatedNumIterations() {
        return this.estimatedNumIterations;
    }

    public void addCleanup(Runnable cleanup) {
        this.cleanups.add(cleanup);
    }

    public List<Runnable> getCleanups() {
        return this.cleanups;
    }

    @Override
    public String getDisplayName() {
        return this.displayName == null ? this.getName() : this.displayName;
    }

    @Override
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }
}

