/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class IoUtil {
    public static String getText(Reader reader) throws IOException {
        try (BufferedReader buffered = new BufferedReader(reader);){
            StringBuilder source = new StringBuilder();
            String line = buffered.readLine();
            while (line != null) {
                source.append(line);
                source.append('\n');
                line = buffered.readLine();
            }
            String string = source.toString();
            return string;
        }
    }

    public static String getText(File path) throws IOException {
        return IoUtil.getText(new FileReader(path));
    }

    public static String getText(InputStream stream) throws IOException {
        return IoUtil.getText(new InputStreamReader(stream));
    }

    public static void createDirectory(File dir) throws IOException {
        if (!dir.isDirectory() && !dir.mkdirs()) {
            throw new IOException("Failed to create directory: " + dir);
        }
    }

    public static void copyStream(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[8192];
        try (InputStream is = in;
             OutputStream os = out;){
            int read = is.read(buffer);
            while (read > 0) {
                os.write(buffer, 0, read);
                read = is.read(buffer);
            }
        }
    }

    public static void copyFile(File source, File target) throws IOException {
        if (!source.isFile()) {
            throw new IOException(String.format("Error copying file %s to %s; source file does not exist", source, target));
        }
        IoUtil.createDirectory(target.getParentFile());
        IoUtil.doCopyFile(source, target);
        IoUtil.checkSameSize(source, target);
    }

    public static List<File> listFilesRecursively(File baseDir) throws IOException {
        if (!baseDir.exists()) {
            return Collections.emptyList();
        }
        ArrayList<File> result = new ArrayList<File>();
        IoUtil.doListFilesRecursively(baseDir, result);
        return result;
    }

    public static String getFileExtension(String filename) {
        int index = filename.lastIndexOf(46);
        return index == -1 ? null : filename.substring(index + 1);
    }

    private static void doListFilesRecursively(File baseDir, List<File> result) throws IOException {
        ArrayList<File> dirs = new ArrayList<File>();
        File[] files = baseDir.listFiles();
        if (files == null) {
            throw new IOException("Failed to list files of directory '" + baseDir + "'");
        }
        for (File file : files) {
            if (file.isFile()) {
                result.add(file);
                continue;
            }
            dirs.add(file);
        }
        for (File dir : dirs) {
            IoUtil.doListFilesRecursively(dir, result);
        }
    }

    private static void doCopyFile(File source, File target) throws IOException {
        try (FileInputStream in = new FileInputStream(source);
             FileOutputStream out = new FileOutputStream(target);){
            in.getChannel().transferTo(0L, Long.MAX_VALUE, out.getChannel());
        }
    }

    private static void checkSameSize(File source, File target) throws IOException {
        long toSize;
        long fromSize = source.length();
        if (fromSize != (toSize = target.length())) {
            throw new IOException(String.format("Error copying file %s to %s; source file size is %d, but target file size is %d", source, target, fromSize, toSize));
        }
    }
}

