/*
 * Decompiled with CFR 0.152.
 */
package spock.util.io;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.jetbrains.annotations.NotNull;
import spock.util.io.DirectoryFixture;

public class FileSystemFixture
implements DirectoryFixture {
    private final Path currentPath;
    private final Class<?> contextClass;

    public FileSystemFixture(Path currentPath) {
        this.currentPath = currentPath;
        this.contextClass = FileSystemFixture.class;
    }

    private FileSystemFixture(Path currentPath, Class<?> contextClass) {
        this.currentPath = currentPath;
        this.contextClass = contextClass;
    }

    public Path getCurrentPath() {
        return this.currentPath;
    }

    public Path resolve(String path) {
        return this.currentPath.resolve(path);
    }

    public Path resolve(Path path) {
        return this.currentPath.resolve(path);
    }

    public void create(@DelegatesTo(value=DirectoryFixture.class, strategy=1) Closure<?> dirSpec) throws IOException {
        this.callSpec(dirSpec, this.currentPath);
    }

    @Override
    public Path dir(String dir) throws IOException {
        Path result = this.currentPath.resolve(dir);
        Files.createDirectories(result, new FileAttribute[0]);
        return result;
    }

    @Override
    public Path dir(String dir, Closure<?> dirSpec) throws IOException {
        Path result = this.dir(dir);
        this.callSpec(dirSpec, result);
        return result;
    }

    @Override
    public Path file(String file) throws IOException {
        Path result = this.currentPath.resolve(file);
        Files.createDirectories(result.getParent(), new FileAttribute[0]);
        return result;
    }

    @Override
    public Path copyFromClasspath(String resourcePath) throws IOException {
        return this.copyFromClasspath(resourcePath, this.getTargetName(resourcePath));
    }

    @NotNull
    private String getTargetName(String resourcePath) {
        return resourcePath.substring(resourcePath.lastIndexOf(47) + 1);
    }

    @Override
    public Path copyFromClasspath(String resourcePath, String targetName) throws IOException {
        return this.copyFromClasspath(resourcePath, targetName, this.contextClass);
    }

    @Override
    public Path copyFromClasspath(String resourcePath, Class<?> contextClass) throws IOException {
        return this.copyFromClasspath(resourcePath, this.getTargetName(resourcePath), contextClass);
    }

    @Override
    public Path copyFromClasspath(String resourcePath, String targetName, Class<?> contextClass) throws IOException {
        URL resource = contextClass.getResource(resourcePath);
        if (resource == null) {
            throw new IOException("Could not find resource: " + resourcePath);
        }
        return this.copyResource(resource, this.file(targetName));
    }

    @NotNull
    private Path copyResource(URL resource, Path file) throws IOException {
        try (InputStream inputStream = resource.openStream();){
            Files.copy(inputStream, file, new CopyOption[0]);
        }
        return file;
    }

    private void callSpec(Closure<?> dirSpec, Path path) {
        Class<?> newContextClass = this.contextClass;
        Object owner = dirSpec.getOwner();
        if (owner instanceof Class) {
            newContextClass = (Class<?>)owner;
        } else if (owner != null) {
            newContextClass = owner.getClass();
        }
        FileSystemFixture fileSystemFixture = new FileSystemFixture(path, newContextClass);
        dirSpec.setResolveStrategy(1);
        dirSpec.setDelegate((Object)fileSystemFixture);
        dirSpec.call();
    }
}

