/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.security;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import pl.decerto.hyperon.common.security.SystemRoleConverter;
import pl.decerto.hyperon.common.security.domain.SystemRoleJPA;
import pl.decerto.hyperon.common.security.domain.SystemUserJPA;
import pl.decerto.hyperon.common.security.domain.SystemUserPreferenceJPA;
import pl.decerto.hyperon.common.security.dto.SystemRole;
import pl.decerto.hyperon.common.security.dto.SystemUser;
import pl.decerto.hyperon.common.security.dto.SystemUserPreference;
import pl.decerto.hyperon.common.security.mapper.SystemRoleMapper;
import pl.decerto.hyperon.common.security.mapper.SystemUserFullMapper;
import pl.decerto.hyperon.common.security.mapper.SystemUserMapper;
import pl.decerto.hyperon.common.security.mapper.SystemUserPreferenceMapper;

@Service
public class UserManagementMappers {
    private final SystemUserMapper userMapper;
    private final SystemUserFullMapper userFullMapper;
    private final SystemRoleMapper roleMapper;
    private final SystemUserPreferenceMapper preferenceMapper;
    private final SystemRoleConverter systemRoleConverter;

    @Autowired
    public UserManagementMappers(SystemUserMapper userMapper, SystemUserFullMapper userFullMapper, SystemRoleMapper roleMapper, SystemUserPreferenceMapper preferenceMapper, SystemRoleConverter systemRoleConverter) {
        this.userMapper = userMapper;
        this.userFullMapper = userFullMapper;
        this.roleMapper = roleMapper;
        this.preferenceMapper = preferenceMapper;
        this.systemRoleConverter = systemRoleConverter;
    }

    SystemUser simpleUserToDto(SystemUserJPA model) {
        return this.userMapper.toDto(model);
    }

    SystemUser fullUserToDto(SystemUserJPA model) {
        return this.userFullMapper.toDto(model);
    }

    SystemUserJPA fullUserToModel(SystemUser dto) {
        return this.userFullMapper.toModel(dto);
    }

    SystemRoleJPA simpleRoleToModel(SystemRole dto) {
        return this.roleMapper.toModel(dto);
    }

    SystemRoleJPA complexRoleToModel(SystemRole dto) {
        return this.systemRoleConverter.toModel(dto);
    }

    SystemUserPreferenceJPA simplePreferenceToModel(SystemUserPreference dto) {
        return this.preferenceMapper.toModel(dto);
    }
}

