/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.security.cache;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import pl.decerto.hyperon.common.security.domain.SystemRights;

public class UserCacheEntry {
    private int id;
    private Set<String> rights = new HashSet<String>();
    private Map<String, String> preferences = new HashMap<String, String>();
    private Set<String> domainReadRights = new HashSet<String>();
    private Set<String> domainWriteRights = new HashSet<String>();
    private Set<String> categoryReadRights = new HashSet<String>();
    private Set<String> categoryWriteRights = new HashSet<String>();
    private boolean readNoACParams;
    private boolean readACParams;

    public void addRight(String rightCode) {
        this.rights.add(rightCode.intern());
        if (rightCode.startsWith("PROD_R_")) {
            this.domainReadRights.add(rightCode.intern());
        }
        if (rightCode.startsWith("PROD_W_")) {
            this.domainWriteRights.add(rightCode.intern());
        }
        if (rightCode.startsWith(SystemRights.PAR_R.name())) {
            this.categoryReadRights.add(rightCode.intern());
            if (SystemRights.PAR_R.name().equals(rightCode) || SystemRights.PAR_R_ALL.name().equals(rightCode)) {
                this.readNoACParams = true;
            } else if (rightCode.startsWith(SystemRights.PAR_R_CAT_.name())) {
                this.readACParams = true;
            }
        }
        if (rightCode.startsWith(SystemRights.PAR_W.name())) {
            this.categoryWriteRights.add(rightCode.intern());
        }
    }

    public void addPreference(String key, String value) {
        this.preferences.put(key.intern(), value.intern());
    }

    public boolean hasRight(String rightCode) {
        return this.rights.contains(rightCode);
    }

    public String getCurrentProfile() {
        return this.preferences.get("DOMAIN_PROFILE");
    }

    public String getPreference(String key) {
        return this.preferences.get(key);
    }

    public void clearPreferences() {
        this.preferences.clear();
    }

    public boolean canReadNoACParams() {
        return this.readNoACParams;
    }

    public boolean canReadAnyACParam() {
        return this.readACParams;
    }

    public String toString() {
        return "UserCacheEntry [id=" + this.id + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserCacheEntry that = (UserCacheEntry)o;
        return this.id == that.id && this.readNoACParams == that.readNoACParams && this.readACParams == that.readACParams && Objects.equals(this.rights, that.rights) && Objects.equals(this.preferences, that.preferences) && Objects.equals(this.domainReadRights, that.domainReadRights) && Objects.equals(this.domainWriteRights, that.domainWriteRights) && Objects.equals(this.categoryReadRights, that.categoryReadRights) && Objects.equals(this.categoryWriteRights, that.categoryWriteRights);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.rights, this.preferences, this.domainReadRights, this.domainWriteRights, this.categoryReadRights, this.categoryWriteRights, this.readNoACParams, this.readACParams);
    }

    public int getId() {
        return this.id;
    }

    public Set<String> getRights() {
        return this.rights;
    }

    public Map<String, String> getPreferences() {
        return this.preferences;
    }

    public Set<String> getDomainReadRights() {
        return this.domainReadRights;
    }

    public Set<String> getDomainWriteRights() {
        return this.domainWriteRights;
    }

    public Set<String> getCategoryReadRights() {
        return this.categoryReadRights;
    }

    public Set<String> getCategoryWriteRights() {
        return this.categoryWriteRights;
    }

    public void setId(int id) {
        this.id = id;
    }
}

