/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.security.configuration;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.DelegatingPasswordEncoder;
import org.springframework.security.crypto.password.MessageDigestPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.crypto.password.Pbkdf2PasswordEncoder;
import pl.decerto.hyperon.common.security.configuration.SecurityProperties;

final class HyperonPasswordEncoderFactories {
    private static final Logger log = LoggerFactory.getLogger(HyperonPasswordEncoderFactories.class);
    private static final String BCRYPT = "bcrypt";
    private static final String PBKDF_2 = "Pbkdf2";
    private static final MessageDigestPasswordEncoder LEGACY_ENCODER = new MessageDigestPasswordEncoder("MD5");
    private static final Pbkdf2PasswordEncoder PBKDF_2_PASSWORD_ENCODER = HyperonPasswordEncoderFactories.getPbkdf2PasswordEncoder();

    private HyperonPasswordEncoderFactories() {
        throw new UnsupportedOperationException("Factory class");
    }

    static PasswordEncoder createDelegatingPasswordEncoder(SecurityProperties securityProperties) {
        String encoder = StringUtils.equals((CharSequence)securityProperties.getPasswordEncoder(), (CharSequence)PBKDF_2) ? PBKDF_2 : BCRYPT;
        ImmutableMap availableEncoders = ImmutableMap.of((Object)BCRYPT, (Object)new BCryptPasswordEncoder(securityProperties.getBcryptComplexity().intValue()), (Object)PBKDF_2, (Object)PBKDF_2_PASSWORD_ENCODER);
        DelegatingPasswordEncoder delegatingPasswordEncoder = new DelegatingPasswordEncoder(encoder, (Map)availableEncoders);
        delegatingPasswordEncoder.setDefaultPasswordEncoderForMatches((PasswordEncoder)LEGACY_ENCODER);
        return delegatingPasswordEncoder;
    }

    private static Pbkdf2PasswordEncoder getPbkdf2PasswordEncoder() {
        Pbkdf2PasswordEncoder pbkdf2PasswordEncoder = new Pbkdf2PasswordEncoder();
        pbkdf2PasswordEncoder.setAlgorithm(Pbkdf2PasswordEncoder.SecretKeyFactoryAlgorithm.PBKDF2WithHmacSHA512);
        return pbkdf2PasswordEncoder;
    }
}

