/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.security.domain;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.PrePersist;
import javax.persistence.SequenceGenerator;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotEmpty;
import pl.decerto.hyperon.common.persistence.jpa.BaseEntity;
import pl.decerto.hyperon.common.security.domain.SystemRoleJPA;

@Entity
public class SystemRightJPA
extends BaseEntity {
    public static final int MAX_DESCRIPTION_LENGTH = 255;
    @Id
    @SequenceGenerator(name="systemrightjpa_id_generator", sequenceName="SEQ_SYSTEM_RIGHT_JPA")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="systemrightjpa_id_generator")
    private int id;
    @Column(nullable=false, unique=true)
    @NotEmpty
    private String code;
    @Column
    private String description;
    @NotNull
    private Date createDate;
    @ManyToMany(mappedBy="rights", fetch=FetchType.EAGER)
    private Set<SystemRoleJPA> roles = new HashSet<SystemRoleJPA>();

    @PrePersist
    public void create() {
        this.createDate = new Date();
    }

    public void setCode(String code) {
        this.code = code.toUpperCase();
    }

    public void addRole(SystemRoleJPA roleJPA) {
        this.roles.add(roleJPA);
    }

    public String toString() {
        return "SystemRightJPA [ id=" + this.id + ", code=" + this.code + ", description=" + this.description + ", createDate=" + this.createDate + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SystemRightJPA roleJPA = (SystemRightJPA)o;
        return this.id == roleJPA.id;
    }

    public int hashCode() {
        return this.id;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public String getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    @NotNull
    public Date getCreateDate() {
        return this.createDate;
    }

    public Set<SystemRoleJPA> getRoles() {
        return this.roles;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setCreateDate(@NotNull Date createDate) {
        this.createDate = createDate;
    }

    public void setRoles(Set<SystemRoleJPA> roles) {
        this.roles = roles;
    }
}

