/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.utils.configuration;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.validation.constraints.NotNull;
import pl.decerto.hyperon.common.utils.collection.CollectionTools;
import pl.decerto.hyperon.common.utils.configuration.ConfigurationContainer;
import pl.decerto.hyperon.common.utils.configuration.ConfigurationItem;
import pl.decerto.hyperon.common.utils.configuration.MultipleConfigurationItem;
import pl.decerto.hyperon.common.utils.configuration.MultipleSingleConfigurationItemsException;
import pl.decerto.hyperon.common.utils.configuration.SingleConfigurationItem;

public class BasicConfigurationContainer<E>
implements ConfigurationContainer<E> {
    @NotNull
    protected List<ConfigurationItem<E>> items = new ArrayList<ConfigurationItem<E>>();

    @Override
    @NotNull
    public <T extends MultipleConfigurationItem<E>> List<T> getMultipleConfigurationItems(@NotNull Class<T> itemClass) {
        return CollectionTools.findItemsOfType(this.items, itemClass);
    }

    @Override
    @NotNull
    public List<ConfigurationItem<E>> getConfigurationItems() {
        return new ArrayList<ConfigurationItem<E>>(this.items);
    }

    @Override
    @NotNull
    public <T extends SingleConfigurationItem<E>> Optional<T> getConfigurationItem(@NotNull Class<T> itemClass) {
        List<T> foundItems = CollectionTools.findItemsOfType(this.items, itemClass);
        if (foundItems.isEmpty()) {
            return Optional.empty();
        }
        if (foundItems.size() > 1) {
            throw new IllegalStateException("Configuration item of type " + SingleConfigurationItem.class.getSimpleName() + " extending " + SingleConfigurationItem.class.getSimpleName() + " has been applied multiple times");
        }
        return Optional.of((SingleConfigurationItem)foundItems.get(0));
    }

    @Override
    @NotNull
    public void addApplicableConfigurationItems(@NotNull Iterable<? extends ConfigurationItem<E>> items, @NotNull E configuredElement) {
        for (ConfigurationItem<E> item : items) {
            if (!item.applicableTo(configuredElement)) continue;
            this.addConfigurationItem(item);
        }
    }

    @Override
    public void addConfigurationItem(@NotNull ConfigurationItem<E> item) {
        if (item instanceof SingleConfigurationItem) {
            this.addSingleConfigurationItem((SingleConfigurationItem)item);
        } else if (item instanceof MultipleConfigurationItem) {
            this.items.add(item);
        } else {
            throw new IllegalArgumentException("Unsupported type of ConfigurationItem: " + item.getClass().getName());
        }
    }

    @Override
    public void addMultipleConfigurationItem(@NotNull MultipleConfigurationItem<E> item) {
        if (item instanceof SingleConfigurationItem) {
            this.verifyNoMultipleApplications((SingleConfigurationItem)((Object)item));
        }
        this.items.add(item);
    }

    @Override
    public void addSingleConfigurationItem(@NotNull SingleConfigurationItem<E> item) {
        this.verifyNoMultipleApplications(item);
        this.items.add(item);
    }

    private void verifyNoMultipleApplications(@NotNull SingleConfigurationItem item) {
        for (ConfigurationItem<E> existingItem : this.items) {
            if (!item.getClass().isInstance(existingItem) && (!(existingItem instanceof SingleConfigurationItem) || !existingItem.getClass().isInstance(item))) continue;
            SingleConfigurationItem itemWithRepeatedClass = item.getClass().isInstance(existingItem) ? item : (SingleConfigurationItem)existingItem;
            throw new MultipleSingleConfigurationItemsException(itemWithRepeatedClass.getClass());
        }
    }
}

