/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.utils.resources;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import pl.decerto.hyperon.common.utils.resources.TypedResourceBundle;

public class YAMLBundleControl<T>
extends TypedResourceBundle.TypedControl<T> {
    private static final List<String> YAML_FORMATS = Collections.singletonList("yml");
    private Class<T> targetClass;

    public YAMLBundleControl(Class<T> targetClass) {
        super(YAML_FORMATS);
        this.targetClass = targetClass;
    }

    @Override
    protected Map<String, T> readMap(BufferedInputStream inputStream) throws IOException {
        ObjectMapper yamlMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        Map props = (Map)yamlMapper.readValue((InputStream)inputStream, (TypeReference)new TypeReference<Map<String, Map>>(){});
        ObjectMapper tMapper = new ObjectMapper();
        return props.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> tMapper.convertValue(e.getValue(), this.targetClass)));
    }
}

