/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.core.versioninterceptor;

import io.higson.runtime.core.versioninterceptor.EffectiveVersionConfiguration;
import io.higson.runtime.exception.MissingActiveVersionException;
import io.higson.runtime.model.RegionVersion;
import io.higson.runtime.model.Schedule;
import io.higson.runtime.model.ScheduleEntry;
import io.higson.runtime.model.region.RegionVersionIdentifier;
import io.higson.runtime.model.region.ScheduleContainer;
import io.higson.runtime.provider.MpScheduleProvider;
import io.higson.runtime.sync.ScheduleCache;
import io.higson.runtime.version.system.SystemVersionProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EffectiveVersionResolver {
    private static final Logger log = LoggerFactory.getLogger(EffectiveVersionResolver.class);
    private final SystemVersionProvider systemVersionProvider;
    private final MpScheduleProvider scheduleProvider;

    public EffectiveVersionResolver(SystemVersionProvider systemVersionProvider, MpScheduleProvider scheduleProvider) {
        this.systemVersionProvider = systemVersionProvider;
        this.scheduleProvider = scheduleProvider;
    }

    public Set<Integer> getEffectiveVersionIds(@NotNull String profileCode, EffectiveVersionConfiguration configuration) {
        return this.getEffectiveVersionIds(profileCode, configuration, Collections.emptyList());
    }

    public Set<Integer> getEffectiveVersionIds(@NotNull String profileCode, EffectiveVersionConfiguration configuration, @NotNull Collection<RegionVersion> userVersions) {
        log.debug("getting effective versions for profile:{} and configuration:{}", (Object)profileCode, (Object)configuration);
        if (Objects.isNull(configuration)) {
            log.debug("returning system active versions with user's versions:{}", userVersions);
            return this.getSystemVersions(profileCode, userVersions);
        }
        log.debug("resolving effective versions using configuration:{}", (Object)configuration);
        return this.getEffectiveVersionIdsUsingConfiguration(profileCode, configuration, userVersions);
    }

    private Set<Integer> getSystemVersions(@NotNull String profileCode, @NotNull Collection<RegionVersion> userVersions) {
        SortedSet userVersionIds = userVersions.stream().map(RegionVersion::getId).collect(Collectors.toCollection(TreeSet::new));
        SortedSet<Integer> systemVersions = this.getSystemVersions(profileCode, userVersions, userVersionIds);
        systemVersions.addAll(userVersionIds);
        return systemVersions;
    }

    private SortedSet<Integer> getSystemVersions(@NotNull String profileCode, @NotNull Collection<RegionVersion> userVersions, SortedSet<Integer> userVersionIds) {
        TreeSet<Integer> versionsToOmit = userVersions.isEmpty() ? new TreeSet<Integer>() : userVersionIds;
        return this.systemVersionProvider.get(profileCode, versionsToOmit);
    }

    private Set<Integer> getEffectiveVersionIdsUsingConfiguration(@NotNull String profileCode, @NotNull EffectiveVersionConfiguration configuration, @NotNull Collection<RegionVersion> userVersions) {
        if (configuration != null && configuration.isSnapshotExportConfiguration()) {
            return this.getAllVersionsForSnapshotExport(configuration);
        }
        ScheduleCache scheduleCache = this.scheduleProvider.cache();
        Map<String, String> regionToActiveVersionMapping = this.getRegionAndActiveVersionsBasedOnEffectiveDate(profileCode, configuration, scheduleCache);
        log.debug("region to active version mapping:{}", regionToActiveVersionMapping);
        this.overrideActiveVersions(userVersions, configuration.getVersionIdentifiers(), regionToActiveVersionMapping);
        log.debug("region to active version mapping after override:{}", regionToActiveVersionMapping);
        Set<Integer> versionIds = this.convertToVersionIds(profileCode, scheduleCache, regionToActiveVersionMapping);
        log.debug("converted version ids:{}", versionIds);
        return versionIds;
    }

    private Set<Integer> getAllVersionsForSnapshotExport(EffectiveVersionConfiguration configuration) {
        return configuration.getAllRegionVersionsOnlyForSnapshotExport().stream().map(RegionVersion::getId).collect(Collectors.toSet());
    }

    private Collection<Schedule> getSchedulesFromCache(@NotNull String profileCode, @NotNull ScheduleCache scheduleCache) {
        return scheduleCache.getSchedules(profileCode).map(ScheduleContainer::getSchedules).orElse(Collections.emptyList());
    }

    private Map<String, String> getRegionAndActiveVersionsBasedOnEffectiveDate(@NotNull String profileCode, @NotNull EffectiveVersionConfiguration configuration, @NotNull ScheduleCache scheduleCache) {
        Collection<Schedule> schedules = this.getSchedulesFromCache(profileCode, scheduleCache);
        return configuration.getDate().map(effectiveDate -> this.createRegionToActiveVersionMapping(profileCode, scheduleCache, schedules, (Date)effectiveDate)).orElseGet(() -> this.createRegionToActiveVersionMapping(profileCode, scheduleCache, schedules));
    }

    private Map<String, String> createRegionToActiveVersionMapping(String profileCode, ScheduleCache cache, Collection<Schedule> schedules, Date effectiveDate) {
        log.debug("using effective date:{}", (Object)effectiveDate);
        HashMap<String, String> regionToActiveVersionMapping = new HashMap<String, String>();
        for (Schedule schedule : schedules) {
            Optional<ScheduleEntry> scheduleEntry = schedule.find(effectiveDate);
            if (scheduleEntry.isPresent()) {
                ScheduleEntry entry = scheduleEntry.get();
                regionToActiveVersionMapping.put(entry.getRegion(), entry.getVersion());
                continue;
            }
            RegionVersion activeVersion = this.getActiveVersion(profileCode, cache, schedule);
            regionToActiveVersionMapping.put(activeVersion.getRegion(), activeVersion.getNumber());
        }
        return regionToActiveVersionMapping;
    }

    private RegionVersion getActiveVersion(String profileCode, ScheduleCache cache, Schedule schedule) {
        return Optional.ofNullable(cache.getActiveVersion(schedule.getRegion())).orElseThrow(() -> new MissingActiveVersionException(profileCode, schedule.getRegion()));
    }

    private Map<String, String> createRegionToActiveVersionMapping(String profileCode, ScheduleCache cache, Collection<Schedule> schedules) {
        HashMap<String, String> regionToActiveVersionMapping = new HashMap<String, String>();
        for (Schedule schedule : schedules) {
            RegionVersion activeVersion = this.getActiveVersion(profileCode, cache, schedule);
            regionToActiveVersionMapping.put(activeVersion.getRegion(), activeVersion.getNumber());
        }
        return regionToActiveVersionMapping;
    }

    private void overrideActiveVersions(@NotNull Collection<RegionVersion> userVersions, @NotNull Set<RegionVersionIdentifier> overridingVersions, @NotNull Map<String, String> regionToActiveVersionMapping) {
        Map<String, String> regionToOverrideVersionMapping = overridingVersions.stream().collect(Collectors.toMap(RegionVersionIdentifier::getRegionCode, RegionVersionIdentifier::getVersion));
        userVersions.forEach(version -> regionToOverrideVersionMapping.merge(version.getRegion(), version.getNumber(), (oldValue, value) -> value));
        regionToActiveVersionMapping.putAll(regionToOverrideVersionMapping);
    }

    private Set<Integer> convertToVersionIds(@NotNull String profileCode, ScheduleCache scheduleCache, Map<String, String> regionToActiveVersionMapping) {
        return regionToActiveVersionMapping.entrySet().stream().map(entry -> this.convertToVersionDto(profileCode, (String)entry.getKey(), (String)entry.getValue(), scheduleCache)).map(RegionVersion::getId).collect(Collectors.toSet());
    }

    private RegionVersion convertToVersionDto(@NotNull String profileCode, String regionCode, String version, ScheduleCache scheduleCache) {
        return scheduleCache.getVersionData(profileCode, regionCode, version).orElseGet(this.getActiveVersion(profileCode, regionCode, scheduleCache));
    }

    private Supplier<RegionVersion> getActiveVersion(@NotNull String profileCode, String regionCode, ScheduleCache scheduleCache) {
        return () -> scheduleCache.getActiveVersion(profileCode, regionCode).orElseThrow(() -> new MissingActiveVersionException(profileCode, regionCode));
    }
}

