/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.engine.types.date;

import io.higson.runtime.engine.annotated.annotations.ParamType;
import io.higson.runtime.engine.core.type.Type;
import io.higson.runtime.engine.types.date.AbstractDateType;
import io.higson.runtime.engine.types.date.DateHolder;
import io.higson.runtime.engine.types.date.SimpleDateFormatPool;
import io.higson.runtime.engine.util.EngineUtil;
import io.higson.runtime.utils.HprDate;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;

@ParamType(value="date")
public class DateType
extends AbstractDateType<Date>
implements Type<DateHolder> {
    @Override
    public String encode(DateHolder holder) {
        return holder.getString();
    }

    @Override
    public DateHolder decode(String text) {
        Date date = EngineUtil.hasText(text) ? (Date)this.guess(text) : null;
        return new DateHolder(date);
    }

    @Override
    public DateHolder convert(Object obj) {
        if (obj instanceof Date) {
            return new DateHolder((Date)obj);
        }
        if (obj instanceof Calendar) {
            Calendar cal = (Calendar)obj;
            return new DateHolder(cal.getTime());
        }
        if (obj instanceof LocalDate) {
            return new DateHolder(Date.from(((LocalDate)obj).atStartOfDay(ZoneId.systemDefault()).toInstant()));
        }
        if (obj instanceof LocalDateTime) {
            return new DateHolder(Date.from(((LocalDateTime)obj).toLocalDate().atStartOfDay(ZoneId.systemDefault()).toInstant()));
        }
        if (obj == null) {
            return new DateHolder(null);
        }
        if (obj instanceof String) {
            return this.decode((String)obj);
        }
        throw new IllegalArgumentException("conversion not supported for: " + obj.getClass());
    }

    public DateHolder[] newArray(int size) {
        return new DateHolder[size];
    }

    @Override
    protected Date parse(String dateStr, String pattern) {
        try {
            return SimpleDateFormatPool.get(pattern).parse(dateStr);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Cannot parse date string [" + dateStr + "]", e);
        }
    }

    public boolean canDecode(String text) {
        String input = text.trim();
        String dateText = text;
        String timeText = "";
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (!Character.isWhitespace(c)) continue;
            dateText = input.substring(0, i).trim();
            timeText = input.substring(i, input.length()).trim();
            break;
        }
        return HprDate.canDecode(dateText) && timeText.isBlank();
    }
}

