/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.engine.util.reflection;

import eu.infomas.annotation.AnnotationDetector;
import io.higson.runtime.engine.util.reflection.PackageFilteringReporter;
import io.higson.runtime.engine.util.reflection.ReflectionsHelper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;

public class AnnotatedMethodReporter
extends PackageFilteringReporter
implements AnnotationDetector.MethodReporter {
    private Class<? extends Annotation> reportedClass;
    private Set<Method> annotatedMethods = new HashSet<Method>();
    private Set<String> scannedClasses = new HashSet<String>();

    public AnnotatedMethodReporter(Class<? extends Annotation> reportedClass, String ... packagesToScan) {
        super(reportedClass.getClassLoader(), packagesToScan);
        this.reportedClass = reportedClass;
    }

    public AnnotatedMethodReporter(ClassLoader classLoader, Class<? extends Annotation> reportedClass, String ... packagesToScan) {
        super(classLoader, packagesToScan);
        this.reportedClass = reportedClass;
    }

    public void reportMethodAnnotation(Class<? extends Annotation> annotation, String className, String methodName) {
        if (!this.scannedClasses.contains(className) && this.isWanted(className)) {
            this.scannedClasses.add(className);
            Class<?> classInstance = this.loadClass(className);
            this.annotatedMethods.addAll(ReflectionsHelper.findMethodsAnnotatedWith(annotation, classInstance));
        }
    }

    public Class<? extends Annotation>[] annotations() {
        return new Class[]{this.reportedClass};
    }

    public Set<Method> getAnnotatedMethods() {
        return this.annotatedMethods;
    }
}

