/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.sql;

import io.higson.runtime.sql.RuntimeDialect;
import io.higson.runtime.sql.dialect.DefaultDialect;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class DialectPrinter {
    private DialectPrinter() {
        throw new UnsupportedOperationException("util class");
    }

    public static String print(RuntimeDialect dialect) {
        StringBuilder sb = new StringBuilder();
        DialectPrinter.line(sb, "dialect class name", dialect.getClass().getName());
        DialectPrinter.line(sb, "jdbc driver class", dialect.jdbcDriverClassName());
        DialectPrinter.line(sb, "hibernate dialect", dialect.hibernateDialect());
        DialectPrinter.line(sb, "select from sequence query", dialect.selectFromSequence("[seq]"));
        DialectPrinter.line(sb, "validation query", dialect.validationQuery());
        if (dialect instanceof DefaultDialect) {
            DefaultDialect dd = (DefaultDialect)dialect;
            DialectPrinter.printNameMapping(sb, "column name replacements", dd.getColumnAliases());
            DialectPrinter.printNameMapping(sb, "table  name replacements", dd.getTableAliases());
        }
        return sb.toString();
    }

    private static void line(StringBuilder sb, String key, String value) {
        sb.append("\n ").append(StringUtils.rightPad((String)key, (int)32)).append(" : ").append(value);
    }

    private static void printNameMapping(StringBuilder sb, String title, Map<String, String> map) {
        if (!map.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                buf.append(entry.getKey()).append(" -> ").append(entry.getValue()).append("  ");
            }
            DialectPrinter.line(sb, title, buf.toString());
        }
    }
}

