/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.engine.config.pico;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.smartparam.engine.core.function.FunctionCache;
import org.smartparam.engine.core.prepared.PreparedParamCache;

public abstract class ComponentConfig {
    private final List<Object> userComponents = new ArrayList<Object>();
    private final List<Object> defaultComponents = new ArrayList<Object>();
    private List<Object> components;

    protected abstract void injectDefaults(List<Object> var1);

    private List<Object> createFinalComponents() {
        ArrayList<Object> finalComponents = new ArrayList<Object>(this.defaultComponents);
        for (Object component : this.userComponents) {
            if (component instanceof FunctionCache || component instanceof PreparedParamCache) {
                this.remove(finalComponents, component);
            }
            finalComponents.add(component);
        }
        return finalComponents;
    }

    private void remove(List<Object> components, Object userObject) {
        Iterator<Object> it = components.iterator();
        while (it.hasNext()) {
            Class clazz;
            Object obj = it.next();
            if (!(obj instanceof Class) || !(clazz = (Class)obj).isAssignableFrom(userObject.getClass())) continue;
            it.remove();
        }
    }

    public List<Object> getComponents() {
        if (this.components == null) {
            this.injectDefaults(this.defaultComponents);
            this.components = this.createFinalComponents();
        }
        return Collections.unmodifiableList(this.components);
    }

    public void addComponent(Object component) {
        this.userComponents.add(component);
    }

    public void setComponents(List<Object> components) {
        this.userComponents.clear();
        this.userComponents.addAll(components);
    }
}

