/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.engine.util.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.smartparam.engine.util.reflection.InnerReflectiveOperationException;

public final class ReflectionsConstructorUtil {
    private ReflectionsConstructorUtil() {
        throw new UnsupportedOperationException();
    }

    public static <T> T createObject(Class<T> objectClass) {
        return ReflectionsConstructorUtil.createObject(objectClass, new Class[0], new Object[0]);
    }

    public static <T> T createObject(Class<T> objectClass, Class<?>[] constructorArgsClasses, Object[] constructorArgs) {
        try {
            Constructor<T> constructor = objectClass.getConstructor(constructorArgsClasses);
            constructor.setAccessible(true);
            return ReflectionsConstructorUtil.createObject(constructor, constructorArgs);
        }
        catch (IllegalArgumentException | NoSuchMethodException | SecurityException illegalArgumentException) {
            ReflectionsConstructorUtil.throwExceptionForObjectConstruction(illegalArgumentException, objectClass, constructorArgs);
            return null;
        }
    }

    public static <T> T createObject(Constructor<?> constructor, Object[] constructorArgs) {
        try {
            return (T)constructor.newInstance(constructorArgs);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException ex) {
            ReflectionsConstructorUtil.throwExceptionForObjectConstruction(ex, constructor, constructorArgs);
            return null;
        }
    }

    private static void throwExceptionForObjectConstruction(Exception exception, Class<?> objectClass, Object[] constructorArgs) {
        throw new InnerReflectiveOperationException(exception, String.format("no String[%d] constructor found for class %s", constructorArgs.length, objectClass.getCanonicalName()));
    }

    private static void throwExceptionForObjectConstruction(Exception exception, Constructor<?> constructor, Object[] constructorArgs) {
        throw new InnerReflectiveOperationException(exception, String.format("no %d-parameter constructor found for class %s", constructorArgs.length, constructor.getDeclaringClass().getCanonicalName()));
    }
}

