/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.cache;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.decerto.hyperon.runtime.model.RegionVersion;

public class UserRegionVersionCache {
    private static final Logger log = LoggerFactory.getLogger(UserRegionVersionCache.class);
    private final Map<CacheKey, Set<RegionVersion>> cache = new ConcurrentHashMap<CacheKey, Set<RegionVersion>>();

    public void put(@NotNull String profileCode, @NotNull String user, @NotNull Set<RegionVersion> versions) {
        CacheKey cacheKey = new CacheKey(profileCode, user);
        if (log.isDebugEnabled()) {
            log.debug("Caching user region versions: {} for key: {}", versions, (Object)cacheKey);
        }
        this.cache.put(cacheKey, versions);
    }

    public Set<RegionVersion> get(@NotNull String profileCode, @NotNull String user) {
        CacheKey cacheKey = new CacheKey(profileCode, user);
        if (log.isDebugEnabled()) {
            log.debug("Getting cached user region versions for key {}", (Object)cacheKey);
        }
        return this.cache.get(cacheKey);
    }

    public void invalidateForProfile(@NotNull String profileCode) {
        if (log.isDebugEnabled()) {
            log.debug("Invalidating cached user region versions associated with profile: {}", (Object)profileCode);
        }
        this.cache.entrySet().removeIf(entry -> StringUtils.equalsIgnoreCase((CharSequence)((CacheKey)entry.getKey()).profileCode, (CharSequence)profileCode));
    }

    public void invalidateForUser(@NotNull String user) {
        log.debug("invalidating cache for user:{}", (Object)user);
        this.cache.entrySet().removeIf(entry -> StringUtils.equalsIgnoreCase((CharSequence)((CacheKey)entry.getKey()).user, (CharSequence)user));
    }

    public void invalidate(@NotNull String profileCode, @NotNull String user) {
        log.debug("invalidating cache for user:{} and profile:{}", (Object)user, (Object)profileCode);
        this.cache.remove(new CacheKey(profileCode, user));
    }

    public Set<CacheKey> getAllKeys() {
        return this.cache.keySet();
    }

    public static final class CacheKey {
        private final String profileCode;
        private final String user;

        public CacheKey(String profileCode, String user) {
            this.profileCode = StringUtils.upperCase((String)profileCode);
            this.user = StringUtils.upperCase((String)user);
        }

        public String getProfileCode() {
            return this.profileCode;
        }

        public String getUser() {
            return this.user;
        }

        public String toString() {
            return "UserRegionVersionCache.CacheKey(profileCode=" + this.getProfileCode() + ", user=" + this.getUser() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            String this$profileCode = this.getProfileCode();
            String other$profileCode = other.getProfileCode();
            if (this$profileCode == null ? other$profileCode != null : !this$profileCode.equals(other$profileCode)) {
                return false;
            }
            String this$user = this.getUser();
            String other$user = other.getUser();
            return !(this$user == null ? other$user != null : !this$user.equals(other$user));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $profileCode = this.getProfileCode();
            result = result * 59 + ($profileCode == null ? 43 : $profileCode.hashCode());
            String $user = this.getUser();
            result = result * 59 + ($user == null ? 43 : $user.hashCode());
            return result;
        }
    }
}

