/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.cache;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.decerto.hyperon.runtime.cache.UserRegionVersionCache;
import pl.decerto.hyperon.runtime.dao.DomainCacheJdbcDao;
import pl.decerto.hyperon.runtime.model.RegionVersion;

public class UserRegionVersionProvider {
    private static final Logger log = LoggerFactory.getLogger(UserRegionVersionProvider.class);
    private final DomainCacheJdbcDao domainCacheJdbcDao;
    private final UserRegionVersionCache userRegionVersionCache;

    public Set<RegionVersion> get(@NotNull String profileCode, @NotNull String user) {
        log.debug("trying to get versions for user:{} and profile:{} from cache", (Object)user, (Object)profileCode);
        Set<RegionVersion> cachedVersions = this.userRegionVersionCache.get(profileCode, user);
        if (cachedVersions != null) {
            log.debug("returning cached {} user region versions", (Object)cachedVersions.size());
            return cachedVersions;
        }
        log.debug("Cache miss for profileCode: {} and user {}", (Object)profileCode, (Object)user);
        List<RegionVersion> versions = this.domainCacheJdbcDao.getUserVersions(profileCode, user);
        if (CollectionUtils.isEmpty(versions)) {
            log.debug("Versions for profileCode: {} and user: {} do not exist in db", (Object)profileCode, (Object)user);
        }
        HashSet<RegionVersion> versionSet = CollectionUtils.isNotEmpty(versions) ? new HashSet<RegionVersion>(versions) : Collections.emptySet();
        this.userRegionVersionCache.put(profileCode, user, versionSet);
        return versionSet;
    }

    public UserRegionVersionProvider(DomainCacheJdbcDao domainCacheJdbcDao, UserRegionVersionCache userRegionVersionCache) {
        this.domainCacheJdbcDao = domainCacheJdbcDao;
        this.userRegionVersionCache = userRegionVersionCache;
    }
}

