/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.dao;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartparam.engine.util.EngineUtil;
import pl.decerto.hyperon.runtime.dao.BaseDao;
import pl.decerto.hyperon.runtime.dao.util.ConnectionInterceptor;
import pl.decerto.hyperon.runtime.function.FunctionType;
import pl.decerto.hyperon.runtime.function.log.FunctionLogLevel;
import pl.decerto.hyperon.runtime.model.Function;
import pl.decerto.hyperon.runtime.model.GroovyFunction;
import pl.decerto.hyperon.runtime.model.PythonFunction;
import pl.decerto.hyperon.runtime.model.RhinoFunction;
import pl.decerto.hyperon.runtime.sql.DialectRegistry;
import pl.decerto.hyperon.runtime.sql.DialectTemplate;
import pl.decerto.hyperon.runtime.sync.Trackable;

public class FunctionJdbcDao
extends BaseDao {
    private static final Logger log = LoggerFactory.getLogger(FunctionJdbcDao.class);
    private final DialectTemplate dialect = DialectRegistry.getDialectTemplate();

    public FunctionJdbcDao(DataSource dataSource, ConnectionInterceptor connectionInterceptor) {
        super(dataSource, connectionInterceptor);
    }

    public Function getFunction(String code, String ver, int sid) {
        log.debug("enter getFunction, code={}, ver={}, sid={}", new Object[]{code, ver, sid});
        boolean head = this.isHead(sid);
        boolean version = this.isVersion(ver);
        String sql = this.createSelect(version, head);
        log.trace("using sql: {}", (Object)sql);
        List<Object> args = this.bindArguments(code, ver, sid, head, version);
        Function f = this.getOne(this.jdbcTemplate(), sql, (rs, rowNum) -> this.mapResultToFunction(rs), args.toArray());
        if (f != null && StringUtils.isNotBlank((CharSequence)f.getArgs())) {
            Map<String, String> argumentToType = this.getArgumentToType(f.getImplId(), f.getArgs());
            f.setArgumentToType(argumentToType);
        }
        log.debug("leave getFunction, found={}", (Object)f);
        return f;
    }

    private Function mapResultToFunction(ResultSet rs) throws SQLException {
        String name = rs.getString("fname");
        String type = rs.getString("itype");
        int id = rs.getInt("fid");
        int implId = rs.getInt("iid");
        Timestamp lastUpdate = rs.getTimestamp("flast");
        String args1 = rs.getString("ia");
        String body = rs.getString("ib");
        FunctionLogLevel logLevel = FunctionLogLevel.ofNullable(rs.getString("log_level"));
        if (FunctionType.RHINO.isEqualTo(type)) {
            return new RhinoFunction(id, implId, name, args1, body, lastUpdate, logLevel);
        }
        if (FunctionType.GROOVY.isEqualTo(type)) {
            return new GroovyFunction(id, implId, name, args1, body, lastUpdate, logLevel);
        }
        if (FunctionType.PYTHON.isEqualTo(type)) {
            return new PythonFunction(id, implId, name, args1, body, lastUpdate, logLevel);
        }
        log.warn("unsupported function type: {}", (Object)type);
        return null;
    }

    private List<Object> bindArguments(String code, String ver, int sid, boolean head, boolean version) {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(code);
        if (version) {
            args.add(ver);
        }
        if (!head) {
            args.add(sid);
        }
        return args;
    }

    private boolean isVersion(String ver) {
        return ver != null;
    }

    private boolean isHead(int sid) {
        return sid == 0;
    }

    private String createSelect(boolean version, boolean head) {
        StringBuilder sb = new StringBuilder();
        if (version) {
            this.append(" select", sb);
            this.append("   f.id as fid, f.$name as fname, f.lastupdate as flast, f.log_level,", sb);
            this.append("   impl.id as iid, impl.$type as itype, impl.args as ia, impl.body as ib", sb);
            this.append(" from @hyp_function f", sb);
            this.append("   inner join @functionimpl impl on f.implementation_id = impl.id", sb);
            this.append("   inner join @regionversion rv on f.regionversion_id = rv.id", sb);
            this.append(" where f.$name = ?", sb);
            this.append("   and f.$archive = 0", sb);
            this.append("   and rv.versionnumber = ?", sb);
            this.append("   and f.head = 1", sb, head);
            this.append("   and f.worksessionid = ?", sb, !head);
        } else {
            this.append(" select", sb);
            this.append("   f.id as fid, f.$name as fname, f.lastupdate as flast, f.log_level,", sb);
            this.append("   impl.id as iid, impl.$type as itype, impl.args as ia, impl.body as ib", sb);
            this.append(" from @hyp_function f", sb);
            this.append("   inner join @functionimpl impl on f.implementation_id = impl.id", sb);
            this.append("   left join @regionversion rv on f.regionversion_id = rv.id", sb);
            this.append(" where f.$name = ?", sb);
            this.append("   and f.$archive = 0", sb);
            this.append("   and (rv.active is null or rv.active = 1)", sb);
            this.append("   and f.head = 1", sb, head);
            this.append("   and f.worksessionid = ?", sb, !head);
        }
        String sql = sb.toString();
        return this.dialect.parse(sql);
    }

    public java.util.Date getMaxLastUpdate() {
        String sql = this.dialect.parse("select max(lastupdate) from @hyp_function");
        return this.jdbcTemplate().queryForObject(sql, java.util.Date.class);
    }

    public List<Trackable> getAllLastUpdates() {
        long t = System.currentTimeMillis();
        String sql = this.dialect.parse("select id, $name, lastupdate from @hyp_function where $archive = 0");
        List<Trackable> result = this.jdbcTemplate(1000).query(sql, (rs, i) -> new Trackable(rs.getInt(1), rs.getString(2), rs.getTimestamp(3)));
        log.debug("leave getAllLastUpdates, size={}, time={}", (Object)result.size(), (Object)(System.currentTimeMillis() - t));
        return result;
    }

    public List<Function> getAllHeads() {
        return this.jdbcTemplate(500).query(this.dialect.parse(" select id, implementation_id, $name, $type, lastupdate, regionversion_id from @hyp_function where head = 1 and $archive = 0"), (rs, i) -> {
            int id = rs.getInt("id");
            int implId = rs.getInt("implementation_id");
            String name = this.dialect.getString(rs, "name");
            String type = this.dialect.getString(rs, "type");
            Date lastupdate = this.dialect.getTimestamp(rs, "lastupdate");
            int rvid = rs.getInt("regionversion_id");
            return new Function(id, implId, name, type, (java.util.Date)lastupdate, rvid);
        });
    }

    private void append(String line, StringBuilder sb) {
        sb.append(line);
    }

    private void append(String line, StringBuilder sb, boolean condition) {
        if (condition) {
            this.append(line, sb);
        }
    }

    public List<String> getArgumentsForFunction(String functionCode) {
        return this.jdbcTemplate().query(this.dialect.parse(this.createSqlForFunctionArguments()), (rs, i) -> this.dialect.getString(rs, "name"), functionCode);
    }

    private String createSqlForFunctionArguments() {
        return "select fa.$name from @functionformalargument fa inner join @hyp_function f on fa.function_id = f.implementation_id where f.$name=?";
    }

    private Map<String, String> getArgumentToType(int functionId, String args) {
        String[] argsArray = EngineUtil.split(EngineUtil.trimAllWhitespace(args), ',');
        LinkedHashMap<String, String> argsTypes = new LinkedHashMap<String, String>(argsArray.length);
        if (argsArray.length == 0) {
            return argsTypes;
        }
        String sqlSb = "select fa.$name, fa.$datatype from @functionformalargument fa where fa.$function_id=? and fa.$name in (" + StringUtils.repeat((String)"?", (String)",", (int)argsArray.length) + ") order by fa.$ordercolumn";
        this.jdbcTemplate().query(this.dialect.parse(sqlSb), rs -> argsTypes.put(this.dialect.getString(rs, "name"), this.dialect.getString(rs, "datatype")), functionId, argsArray);
        return argsTypes;
    }
}

