/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.sync;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import pl.decerto.hyperon.runtime.cache.ProfileCache;
import pl.decerto.hyperon.runtime.dao.VersionJdbcDao;
import pl.decerto.hyperon.runtime.model.RegionVersion;
import pl.decerto.hyperon.runtime.sync.BaseWatcher;

public class ProfileRuntimeWatcher
extends BaseWatcher {
    private final VersionJdbcDao versionJdbcDao;
    private final ProfileCache profileCache;
    private Date lastRunDate;

    @Override
    protected String getWatcherName() {
        return "profile-runtime-watcher";
    }

    @Override
    protected void doWatch() {
        List<RegionVersion> currentVersions = this.versionJdbcDao.getAllRegionVersionsList();
        Synchronizer synchronizer = new Synchronizer(currentVersions);
        synchronizer.synchronize();
        this.lastRunDate = new Date();
    }

    public ProfileRuntimeWatcher(VersionJdbcDao versionJdbcDao, ProfileCache profileCache) {
        this.versionJdbcDao = versionJdbcDao;
        this.profileCache = profileCache;
    }

    public Date getLastRunDate() {
        return this.lastRunDate;
    }

    private class Synchronizer {
        private final Map<String, String> currentRegionToProfile;
        private final Map<ProfileCache.CacheKey, String> currentRegionAndVersionToProfile;

        Synchronizer(List<RegionVersion> currentVersions) {
            HashMap<String, String> currentRegionToProfile = new HashMap<String, String>();
            HashMap<ProfileCache.CacheKey, String> currentRegionAndVersionToProfile = new HashMap<ProfileCache.CacheKey, String>();
            for (RegionVersion version : currentVersions) {
                currentRegionToProfile.put(version.getRegion(), version.getProfileCode());
                currentRegionAndVersionToProfile.put(new ProfileCache.CacheKey(version.getRegion(), version.getNumber()), version.getProfileCode());
            }
            this.currentRegionToProfile = currentRegionToProfile;
            this.currentRegionAndVersionToProfile = currentRegionAndVersionToProfile;
        }

        private void synchronize() {
            Set<ProfileCache.CacheKey> keys = ProfileRuntimeWatcher.this.profileCache.getAllKeys();
            keys.forEach(this::synchronizeOne);
        }

        private void synchronizeOne(ProfileCache.CacheKey key) {
            ProfileRuntimeWatcher.this.log.debug("Synchronizing cache for key: {}", (Object)key);
            String regionCode = key.getRegionCode();
            String version = key.getVersion();
            if (StringUtils.isBlank((CharSequence)version)) {
                String currentProfile = this.currentRegionToProfile.get(regionCode);
                this.doSynchronizeOne(regionCode, null, currentProfile);
                return;
            }
            String currentProfile = this.currentRegionAndVersionToProfile.get(new ProfileCache.CacheKey(regionCode, version));
            this.doSynchronizeOne(regionCode, version, currentProfile);
        }

        private void doSynchronizeOne(String regionCode, String version, String currentProfile) {
            if (StringUtils.isBlank((CharSequence)currentProfile)) {
                ProfileRuntimeWatcher.this.log.debug("Missing entry in db for regionCode: {} and version {}. Invalidating cache.", (Object)regionCode, (Object)version);
                ProfileRuntimeWatcher.this.profileCache.invalidate(regionCode, version);
                return;
            }
            String cachedProfile = ProfileRuntimeWatcher.this.profileCache.get(regionCode, version);
            if (!StringUtils.equalsIgnoreCase((CharSequence)currentProfile, (CharSequence)cachedProfile)) {
                ProfileRuntimeWatcher.this.log.debug("Cache entry for regionCode: {} and version {} is stale. Invalidating.", (Object)regionCode, (Object)version);
                ProfileRuntimeWatcher.this.profileCache.invalidate(regionCode, version);
            }
        }
    }
}

