/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.core.env;

import io.awspring.cloud.core.env.ResourceIdResolver;
import io.awspring.cloud.core.env.stack.StackResourceRegistry;
import java.util.Collection;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;

public class StackResourceRegistryDetectingResourceIdResolver
implements ResourceIdResolver,
BeanFactoryAware,
InitializingBean {
    private StackResourceRegistry stackResourceRegistry;
    private ListableBeanFactory beanFactory;

    private static StackResourceRegistry findSingleOptionalStackResourceRegistry(ListableBeanFactory beanFactory) {
        Collection stackResourceRegistries = beanFactory.getBeansOfType(StackResourceRegistry.class).values();
        if (stackResourceRegistries.size() > 1) {
            throw new IllegalStateException("Multiple stack resource registries found");
        }
        if (stackResourceRegistries.size() == 1) {
            return (StackResourceRegistry)stackResourceRegistries.iterator().next();
        }
        return null;
    }

    @Override
    public String resolveToPhysicalResourceId(String logicalResourceId) {
        String physicalResourceId;
        if (this.stackResourceRegistry != null && (physicalResourceId = this.stackResourceRegistry.lookupPhysicalResourceId(logicalResourceId)) != null) {
            return physicalResourceId;
        }
        return logicalResourceId;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (!(beanFactory instanceof ListableBeanFactory)) {
            throw new IllegalStateException("Bean factory must be of type '" + ListableBeanFactory.class.getName() + "'");
        }
        this.beanFactory = (ListableBeanFactory)beanFactory;
    }

    public void afterPropertiesSet() throws Exception {
        this.stackResourceRegistry = StackResourceRegistryDetectingResourceIdResolver.findSingleOptionalStackResourceRegistry(this.beanFactory);
    }
}

