/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.core.io.s3;

import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import io.awspring.cloud.core.io.s3.AmazonS3ClientFactory;
import java.lang.reflect.Method;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.Advisor;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public final class AmazonS3ProxyFactory {
    private AmazonS3ProxyFactory() {
        throw new IllegalStateException("Can't instantiate a utility class");
    }

    public static AmazonS3 createProxy(AmazonS3 amazonS3) {
        Assert.notNull((Object)amazonS3, (String)"AmazonS3 client must not be null");
        if (AopUtils.isAopProxy((Object)amazonS3)) {
            Advised advised = (Advised)amazonS3;
            for (Advisor advisor : advised.getAdvisors()) {
                if (!ClassUtils.isAssignableValue(SimpleStorageRedirectInterceptor.class, (Object)advisor.getAdvice())) continue;
                return amazonS3;
            }
            try {
                advised.addAdvice((Advice)new SimpleStorageRedirectInterceptor((AmazonS3)advised.getTargetSource().getTarget()));
            }
            catch (Exception e) {
                throw new RuntimeException("Error adding advice for class amazonS3 instance", e);
            }
            return amazonS3;
        }
        ProxyFactory factory = new ProxyFactory((Object)amazonS3);
        factory.setInterfaces(new Class[]{AmazonS3.class});
        factory.addAdvice((Advice)new SimpleStorageRedirectInterceptor(amazonS3));
        return (AmazonS3)factory.getProxy();
    }

    static final class SimpleStorageRedirectInterceptor
    implements MethodInterceptor {
        private static final Logger LOGGER = LoggerFactory.getLogger(SimpleStorageRedirectInterceptor.class);
        private final AmazonS3 amazonS3;
        private final AmazonS3ClientFactory amazonS3ClientFactory;

        private SimpleStorageRedirectInterceptor(AmazonS3 amazonS3) {
            this.amazonS3 = amazonS3;
            this.amazonS3ClientFactory = new AmazonS3ClientFactory();
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            try {
                return invocation.proceed();
            }
            catch (AmazonS3Exception e) {
                if (301 == e.getStatusCode()) {
                    AmazonS3 redirectClient = this.buildAmazonS3ForRedirectLocation(this.amazonS3, e);
                    return ReflectionUtils.invokeMethod((Method)invocation.getMethod(), (Object)redirectClient, (Object[])invocation.getArguments());
                }
                throw e;
            }
        }

        private AmazonS3 buildAmazonS3ForRedirectLocation(AmazonS3 prototype, AmazonS3Exception e) {
            try {
                Regions redirectRegion;
                try {
                    redirectRegion = Regions.fromName((String)((String)e.getAdditionalDetails().get("x-amz-bucket-region")));
                }
                catch (IllegalArgumentException iae) {
                    redirectRegion = null;
                }
                return this.amazonS3ClientFactory.createClientForEndpointUrl(prototype, "https://" + (String)e.getAdditionalDetails().get("Endpoint"), redirectRegion);
            }
            catch (Exception ex) {
                LOGGER.error("Error getting new Amazon S3 for redirect", (Throwable)ex);
                throw new RuntimeException(e);
            }
        }
    }
}

