/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.core.io.s3;

import com.amazonaws.services.s3.AmazonS3;
import io.awspring.cloud.core.io.s3.AmazonS3ProxyFactory;
import io.awspring.cloud.core.io.s3.SimpleStorageNameUtils;
import io.awspring.cloud.core.io.s3.SimpleStorageResource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.ProtocolResolver;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.task.SyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;

public class SimpleStorageProtocolResolver
implements ProtocolResolver,
InitializingBean,
BeanFactoryAware {
    private AmazonS3 amazonS3;
    private TaskExecutor taskExecutor;
    private BeanFactory beanFactory;

    public SimpleStorageProtocolResolver() {
    }

    public SimpleStorageProtocolResolver(AmazonS3 amazonS3) {
        this.amazonS3 = AmazonS3ProxyFactory.createProxy(amazonS3);
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void afterPropertiesSet() {
        if (this.taskExecutor == null) {
            this.taskExecutor = new SyncTaskExecutor();
        }
    }

    public Resource resolve(String location, ResourceLoader resourceLoader) {
        if (SimpleStorageNameUtils.isSimpleStorageResource(location)) {
            return new SimpleStorageResource(this.getAmazonS3(), SimpleStorageNameUtils.getBucketNameFromLocation(location), SimpleStorageNameUtils.getObjectNameFromLocation(location), this.taskExecutor, SimpleStorageNameUtils.getVersionIdFromLocation(location), SimpleStorageNameUtils.getContentTypeFromLocation(location));
        }
        return null;
    }

    public AmazonS3 getAmazonS3() {
        if (this.amazonS3 == null) {
            this.amazonS3 = AmazonS3ProxyFactory.createProxy((AmazonS3)this.beanFactory.getBean(AmazonS3.class));
        }
        return this.amazonS3;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

