/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.rest.cache.user;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import pl.decerto.hyperon.common.security.dto.SystemUser;

@Component
@ConditionalOnProperty(name={"higson.runtime-rest.security.user-cache-enabled"}, havingValue="true")
public class SystemUserCache {
    private final Map<String, SystemUser> cache = new ConcurrentHashMap<String, SystemUser>();

    public SystemUser get(String login) {
        return this.cache.get(login);
    }

    public void put(String login, SystemUser systemUser) {
        this.cache.put(login, systemUser);
    }

    public void clear() {
        this.cache.clear();
    }
}

