/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.rest.configuration;

import com.zaxxer.hikari.HikariDataSource;
import io.higson.runtime.profiler.jdbc.proxy.DataSourceProxy;
import io.higson.runtime.sql.DialectRegistry;
import io.higson.runtime.sql.DialectTemplate;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportResource;
import org.springframework.security.core.userdetails.UserDetailsService;
import pl.decerto.hyperon.common.configuration.HyperonCommonConfiguration;
import pl.decerto.hyperon.common.configuration.LiquibaseConfiguration;
import pl.decerto.hyperon.common.security.HyperonUserDetailsService;
import pl.decerto.hyperon.common.security.cache.UsersCacheManager;
import pl.decerto.hyperon.common.security.dao.UserManagementDao;
import pl.decerto.hyperon.common.security.mapper.SystemUserMapper;
import pl.decerto.hyperon.rest.configuration.DatabaseProperties;
import pl.decerto.hyperon.rest.configuration.SwaggerConfiguration;
import pl.decerto.hyperon.rest.configuration.security.SecurityConfiguration;
import pl.decerto.hyperon.rest.security.CachingHyperonUserDetailsService;
import pl.decerto.hyperon.rest.security.SystemUserCacheAwareProvider;

@Configuration
@Import(value={SwaggerConfiguration.class, HyperonCommonConfiguration.class, SecurityConfiguration.class, LiquibaseConfiguration.class})
@ImportResource(value={"classpath:hyperon-runtime-rest-jpa.xml"})
public class HyperonRuntimeRestConfiguration {
    @Bean
    public DialectRegistry dialectRegistry(DatabaseProperties databaseProperties) {
        DialectRegistry registry = new DialectRegistry();
        registry.setDialect((Object)databaseProperties.getDialect());
        return registry;
    }

    @Bean
    public DialectTemplate dialectTemplate(DialectRegistry dialectRegistry) {
        return dialectRegistry.create();
    }

    @Bean
    @Qualifier(value="dataSource")
    public DataSource dataSourceProxy(@Qualifier(value="_dataSource") DataSource dataSource) {
        return new DataSourceProxy(dataSource);
    }

    @Bean
    @Qualifier(value="_dataSource")
    public DataSource dataSource(DialectTemplate dialectTemplate, DatabaseProperties databaseProperties) {
        HikariDataSource dataSource = new HikariDataSource();
        dataSource.setUsername(databaseProperties.getDbUsername());
        dataSource.setPassword(databaseProperties.getDbPassword());
        dataSource.setJdbcUrl(databaseProperties.getDbUrl());
        dataSource.setDriverClassName(dialectTemplate.getJdbcDriverClassName());
        return dataSource;
    }

    @Bean
    @ConditionalOnProperty(prefix="higson.security.user", name={"cache"}, havingValue="true")
    UserDetailsService cachingHyperonUserDetailsService(UsersCacheManager usersCacheManager, SystemUserCacheAwareProvider systemUserCacheAwareProvider) {
        return new CachingHyperonUserDetailsService(usersCacheManager, systemUserCacheAwareProvider);
    }

    @Bean
    @ConditionalOnProperty(prefix="higson.security.user", name={"cache"}, havingValue="false", matchIfMissing=true)
    UserDetailsService userDetailsService(UserManagementDao userManagementDao, UsersCacheManager usersCacheManager, SystemUserMapper systemUserMapper) {
        return new HyperonUserDetailsService(userManagementDao, usersCacheManager, systemUserMapper);
    }
}

