/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.rest.configuration.security.jwt;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import java.io.IOException;
import java.util.Objects;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.web.filter.OncePerRequestFilter;
import pl.decerto.hyperon.common.security.domain.JwtToken;
import pl.decerto.hyperon.rest.configuration.security.jwt.JwtAuthFacade;
import pl.decerto.hyperon.rest.configuration.security.jwt.JwtTokenNotValidException;
import pl.decerto.hyperon.rest.configuration.security.jwt.JwtTokenUtils;

public class JwtTokenFilter
extends OncePerRequestFilter {
    private static final String AUTHORIZATION_HEADER_NAME = "Authorization";
    private final JwtAuthFacade facade;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        try {
            this.processFilter(request);
        }
        catch (JwtTokenNotValidException ex) {
            SecurityContextHolder.clearContext();
            this.logger.error((Object)ex.getMessage());
            response.sendError(HttpStatus.FORBIDDEN.value(), ex.getMessage());
            return;
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private void processFilter(HttpServletRequest request) {
        String authorization = request.getHeader(AUTHORIZATION_HEADER_NAME);
        if (StringUtils.isBlank((CharSequence)authorization)) {
            throw new JwtTokenNotValidException("Authorization header not found");
        }
        String token = JwtTokenUtils.getTokenWithoutBearer(authorization);
        if (StringUtils.isBlank((CharSequence)token)) {
            throw new JwtTokenNotValidException("Token not found in authorization header");
        }
        if (Objects.isNull(this.getJwtToken(token))) {
            throw new JwtTokenNotValidException("Token has been revoked");
        }
        Jws<Claims> claims = this.facade.getClaims(token);
        Authentication authentication = this.getAuthentication(claims);
        SecurityContextHolder.getContext().setAuthentication(authentication);
    }

    private Authentication getAuthentication(Jws<Claims> claims) {
        UserDetails userDetails = this.facade.loadUser(claims);
        return new UsernamePasswordAuthenticationToken((Object)userDetails, (Object)"", userDetails.getAuthorities());
    }

    private JwtToken getJwtToken(String token) {
        return (JwtToken)this.facade.getJwtToken(token).get();
    }

    public JwtTokenFilter(JwtAuthFacade facade) {
        this.facade = facade;
    }
}

