/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.rest.security;

import java.util.Optional;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.lang.NonNull;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Component;
import pl.decerto.hyperon.common.security.dao.UserManagementDao;
import pl.decerto.hyperon.common.security.domain.SystemUserJPA;
import pl.decerto.hyperon.common.security.dto.SystemUser;
import pl.decerto.hyperon.common.security.mapper.SystemUserMapper;
import pl.decerto.hyperon.rest.cache.user.SystemUserCache;

@Component
@ConditionalOnProperty(prefix="higson.security.user", name={"cache"}, havingValue="true")
public class SystemUserCacheAwareProvider {
    private final SystemUserCache systemUserCache;
    private final UserManagementDao usersManagementDao;
    private final SystemUserMapper userMapper;

    public SystemUser getSystemUser(@NonNull String login) {
        return Optional.ofNullable(this.systemUserCache.get(login)).orElseGet(() -> this.findAndCache(login));
    }

    private SystemUser findAndCache(String login) {
        SystemUserJPA systemUserJPA = this.usersManagementDao.findByLogin(login);
        if (systemUserJPA == null) {
            throw new UsernameNotFoundException(login);
        }
        SystemUser user = this.userMapper.toDto(systemUserJPA);
        this.systemUserCache.put(login, user);
        return user;
    }

    public SystemUserCacheAwareProvider(SystemUserCache systemUserCache, UserManagementDao usersManagementDao, SystemUserMapper userMapper) {
        this.systemUserCache = systemUserCache;
        this.usersManagementDao = usersManagementDao;
        this.userMapper = userMapper;
    }
}

