/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.core;

import io.higson.runtime.core.DigestElementCodeProcessor;
import io.higson.runtime.core.EmptyParamValue;
import io.higson.runtime.core.HigsonEngine;
import io.higson.runtime.core.domain.DomainCache;
import io.higson.runtime.core.versioninterceptor.EffectiveVersionConfiguration;
import io.higson.runtime.core.versioninterceptor.VersionInterceptor;
import io.higson.runtime.distinct.DistinctFilter;
import io.higson.runtime.engine.core.ParamEngine;
import io.higson.runtime.engine.core.ParamEngineRuntimeConfig;
import io.higson.runtime.engine.core.context.ParamContext;
import io.higson.runtime.engine.core.output.ParamValue;
import io.higson.runtime.exception.HigsonIllegalStateException;
import io.higson.runtime.model.DomainObject;
import io.higson.runtime.model.Parameter;
import io.higson.runtime.model.Type;
import io.higson.runtime.model.proxy.DomainObjectProxy;
import io.higson.runtime.model.region.RegionVersionIdentifier;
import io.higson.runtime.profiler.engine.EngineProfiler;
import io.higson.runtime.rhino.value.RhinoParamValue;
import io.higson.runtime.sorter.ParamSorter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class HigsonEngineImpl
implements HigsonEngine {
    private static final ParamValue EMPTY_PARAM_VALUE = new EmptyParamValue();
    private static final EngineProfiler profiler = EngineProfiler.PARAMETER;
    private final ParamEngine engine;
    private final ParamSorter paramSorter = new ParamSorter();
    private final DistinctFilter distinct = new DistinctFilter();
    private final boolean valueNeverNull;
    private final VersionInterceptor versionInterceptor;
    private final DomainCache domainCache;
    private final DigestElementCodeProcessor digestElementCodeProcessor;

    public HigsonEngineImpl(ParamEngine engine, DomainCache domainCache, VersionInterceptor versionInterceptor, boolean valueNeverNull) {
        this.engine = engine;
        this.domainCache = domainCache;
        this.versionInterceptor = versionInterceptor;
        this.valueNeverNull = valueNeverNull;
        this.digestElementCodeProcessor = new DigestElementCodeProcessor(versionInterceptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParamValue get(String parameterName, ParamContext ctx) {
        long t = System.currentTimeMillis();
        String uid = this.versionInterceptor.decorateParameterUid(parameterName);
        try {
            ParamValue paramValue = this.get0(uid, ctx);
            return paramValue;
        }
        finally {
            profiler.addGetMeasure(uid, t, System.currentTimeMillis());
        }
    }

    @Deprecated
    public ParamValue get0(String uid, ParamContext ctx) {
        this.reset(ctx);
        ParamValue value = this.engine.get(uid, ctx);
        if (value == null) {
            return this.getNull();
        }
        Parameter def = (Parameter)value.getMetadata();
        if (def == null) {
            throw new HigsonIllegalStateException("Parameter metadata not found in cache: " + uid);
        }
        if (def.isDistinct()) {
            value = this.distinct.filter(value);
        }
        if (def.getSort() != null) {
            value = this.paramSorter.sort(value, def.getSort());
        }
        return value;
    }

    @Override
    public Object call(String functionName, ParamContext ctx, Object ... args) {
        this.reset(ctx);
        String uid = this.versionInterceptor.decorateFunctionUid(functionName);
        Object result = this.engine.callFunction(uid, this.merge(ctx, args));
        if (result instanceof RhinoParamValue) {
            result = ((RhinoParamValue)result).unwrap();
        }
        return result;
    }

    @Override
    public ParamEngineRuntimeConfig runtimeConfiguration() {
        return this.engine.runtimeConfiguration();
    }

    @Override
    public void setEffectiveVersion(String region, String version) {
        this.versionInterceptor.setEffectiveVersion(region, version);
    }

    @Override
    public void setEffectiveVersion(String profileCode, String regionCode, String version) {
        this.versionInterceptor.setEffectiveVersion(profileCode, regionCode, version);
    }

    @Override
    public void setEffectiveDate(Date date) {
        this.versionInterceptor.setEffectiveDate(date);
    }

    @Override
    public void clearEffectiveVersion(String region) {
        this.versionInterceptor.clearEffectiveVersion(region);
    }

    @Override
    public void clearEffectiveVersion(String profileCode, String regionCode) {
        this.versionInterceptor.clearEffectiveVersion(profileCode, regionCode);
    }

    @Override
    public void clearEffectiveVersions() {
        this.versionInterceptor.clearEffectiveVersions();
    }

    @Override
    public void clearEffectiveDate() {
        this.versionInterceptor.clearEffectiveDate();
    }

    @Override
    public void clearEffectiveSetup() {
        this.versionInterceptor.clearEffectiveSetup();
    }

    @Override
    public List<String> getProfiles() {
        return new ArrayList<String>(this.domainCache.getProfiles());
    }

    @Override
    public Set<String> getExistingProfiles() {
        return this.domainCache.getProfiles();
    }

    @Override
    public DomainObject getDomain(String profile, String objectPath) {
        DomainObject obj = this.getDomainObject(profile, objectPath);
        return obj != null ? new DomainObjectProxy(obj, this, profile, objectPath) : null;
    }

    @Override
    public String getDigest(Type type, String elementCode) {
        String preprocessedCode = this.digestElementCodeProcessor.preprocess(type, elementCode);
        return this.engine.getDigest(type, preprocessedCode);
    }

    private DomainObject getDomainObject(String profile, String objectPath) {
        Optional<EffectiveVersionConfiguration> effectiveVersionConfiguration = this.createEffectiveVersionConfiguration(profile);
        if (effectiveVersionConfiguration.isPresent()) {
            return this.domainCache.getDomain(profile, objectPath, effectiveVersionConfiguration.get());
        }
        return this.domainCache.getDomain(profile, objectPath);
    }

    private Optional<EffectiveVersionConfiguration> createEffectiveVersionConfiguration(String profile) {
        Set<RegionVersionIdentifier> effectiveVersions = this.versionInterceptor.getEffectiveVersions(profile);
        Date effectiveDate = this.versionInterceptor.getEffectiveDate().orElse(null);
        if (Objects.nonNull(effectiveDate)) {
            return Optional.of(EffectiveVersionConfiguration.withEffectiveVersionsAndDate(effectiveVersions, effectiveDate));
        }
        if (effectiveVersions.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(EffectiveVersionConfiguration.withEffectiveVersions(effectiveVersions));
    }

    private ParamValue getNull() {
        return this.valueNeverNull ? EMPTY_PARAM_VALUE : null;
    }

    private void reset(ParamContext ctx) {
        ctx.setLevelValues(null);
    }

    Object[] merge(ParamContext ctx, Object ... args) {
        if (args == null || args.length == 0) {
            return new Object[]{ctx};
        }
        Object[] result = new Object[args.length + 1];
        result[0] = ctx;
        System.arraycopy(args, 0, result, 1, args.length);
        return result;
    }

    @Deprecated
    public boolean isValueNeverNull() {
        return this.valueNeverNull;
    }

    @Deprecated
    public DomainCache getDomainCache() {
        return this.domainCache;
    }
}

