/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.engine.annotated.scanner;

import io.higson.runtime.engine.annotated.PackageList;
import io.higson.runtime.engine.annotated.scanner.MethodScanner;
import io.higson.runtime.engine.annotated.scanner.NonUniqueFunctionRegisteredException;
import io.higson.runtime.engine.util.reflection.AnnotationHelper;
import io.higson.runtime.engine.util.reflection.ReflectionsScanner;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class PackageMethodScanner
implements MethodScanner {
    private final ReflectionsScanner reflectionsScanner = new ReflectionsScanner();
    private final PackageList packagesToScan;

    public PackageMethodScanner(PackageList packagesToScan) {
        this.packagesToScan = packagesToScan;
    }

    @Override
    public Map<String, Method> scanMethods(Class<? extends Annotation> annotationClass) {
        HashMap<String, Method> methods = new HashMap<String, Method>();
        for (Method method : this.reflectionsScanner.findMethodsAnnotatedWith(annotationClass, this.packagesToScan.getPackages())) {
            String pluginName = (String)AnnotationHelper.extractValue(method.getAnnotation(annotationClass), "value");
            this.checkForDuplicates(methods, pluginName, method);
            methods.put(pluginName, method);
        }
        return methods;
    }

    private void checkForDuplicates(Map<String, Method> methods, String newPluginName, Method newPluginMethod) {
        if (methods.containsKey(newPluginName)) {
            throw new NonUniqueFunctionRegisteredException(newPluginName, methods.get(newPluginName), newPluginMethod);
        }
    }
}

