/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.engine.core.index;

import io.higson.runtime.engine.core.index.LevelNode;
import io.higson.runtime.engine.core.index.SearchResult;
import io.higson.runtime.engine.core.matcher.Matcher;
import io.higson.runtime.engine.core.parameter.MatchMode;
import io.higson.runtime.engine.core.type.Type;
import io.higson.runtime.engine.core.type.ValueHolder;
import java.util.List;

public class LevelIndex<T> {
    private static final int INITIAL_PRINTER_CAPACITY = 256;
    private final int levelCount;
    private final LevelNode<T> root;
    private final Matcher[] matchers;
    private final Type<? extends ValueHolder>[] types;
    private MatchMode[] modes;

    public LevelIndex(int levelCount, Type<? extends ValueHolder>[] types, Matcher ... matchers) {
        this.levelCount = levelCount;
        this.types = new Type[levelCount];
        this.matchers = new Matcher[levelCount];
        if (types != null) {
            System.arraycopy(types, 0, this.types, 0, types.length);
        }
        if (matchers != null) {
            System.arraycopy(matchers, 0, this.matchers, 0, matchers.length);
        }
        this.root = new LevelNode(this);
    }

    public LevelIndex(int levelCount) {
        this(levelCount, null, new Matcher[0]);
    }

    public void add(String[] levelValues, T leaf) {
        this.root.add(levelValues, leaf, 0);
    }

    public List<T> find(String[] ... levelValues) {
        SearchResult result = new SearchResult();
        this.root.findAll(levelValues, 0, result);
        return result.getResult().isEmpty() ? null : result.getResult();
    }

    public List<T> find(String ... levelValues) {
        String[][] targetValues = new String[levelValues.length][1];
        for (int i = 0; i < levelValues.length; ++i) {
            targetValues[i] = new String[]{levelValues[i]};
        }
        return this.find(targetValues);
    }

    public void trim() {
        this.root.trim();
    }

    public String printTree() {
        StringBuilder sb = new StringBuilder(256);
        this.root.printNode(sb, 0);
        return sb.toString();
    }

    public Matcher getMatcher(int depth) {
        return this.matchers[depth];
    }

    public Type<? extends ValueHolder> getType(int depth) {
        return this.types[depth];
    }

    public void setUnion(boolean ... union) {
        this.modes = new MatchMode[union.length];
        for (int i = 0; i < union.length; ++i) {
            this.modes[i] = union[i] ? MatchMode.UNION : MatchMode.STANDARD;
        }
    }

    public void setMatchModes(MatchMode ... modes) {
        this.modes = modes;
    }

    public MatchMode getMatchMode(int depth) {
        return this.modes != null && depth < this.modes.length ? this.modes[depth] : MatchMode.STANDARD;
    }

    public int getLevelCount() {
        return this.levelCount;
    }

    public Matcher[] getMatchers() {
        return this.matchers;
    }

    public Type<? extends ValueHolder>[] getTypes() {
        return this.types;
    }
}

