/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.engine.core.index;

import io.higson.runtime.engine.core.index.LevelIndex;
import io.higson.runtime.engine.core.index.SearchResult;
import io.higson.runtime.engine.core.matcher.Matcher;
import io.higson.runtime.engine.core.parameter.MatchMode;
import io.higson.runtime.engine.core.type.Type;
import io.higson.runtime.engine.core.type.ValueHolder;
import io.higson.runtime.engine.util.Separator;
import io.higson.runtime.helper.LevelConstants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LevelNode<T> {
    private static final float CHILDREN_MAP_LOAD_FACTOR = 0.8f;
    private String level;
    private Map<String, LevelNode<T>> children;
    private LevelNode<T> defaultNode;
    private ArrayList<T> leafList;
    private LevelNode<T> parent;
    private final LevelIndex<T> index;

    public LevelNode(LevelIndex<T> index) {
        this.index = index;
    }

    public LevelNode(String level, LevelNode<T> parent, LevelIndex<T> index) {
        this.level = level;
        this.parent = parent;
        this.index = index;
        this.leafList = null;
    }

    public void add(List<String> levels, T leafValue, int depth) {
        String[] levelsArray = levels.toArray(new String[0]);
        this.add(levelsArray, leafValue, depth);
    }

    public void add(String[] levels, T leafValue, int depth) {
        if (!this.reachedLeafDepth(depth)) {
            String levelVal = this.trim(levels[depth]);
            if (LevelConstants.ASTERISK.getValue().equals(levelVal)) {
                if (this.defaultNode == null) {
                    this.defaultNode = new LevelNode<T>(levelVal, this, this.index);
                }
                this.defaultNode.add(levels, leafValue, depth + 1);
            } else {
                this.ensureChildrenIsReady();
                LevelNode child = this.children.computeIfAbsent(levelVal, fun -> new LevelNode<T>(levelVal, this, this.index));
                child.add(levels, leafValue, depth + 1);
            }
        } else {
            if (this.leafList == null) {
                this.leafList = new ArrayList(1);
            }
            this.leafList.add(leafValue);
        }
    }

    private boolean reachedLeafDepth(int depth) {
        return depth >= this.index.getLevelCount();
    }

    private void ensureChildrenIsReady() {
        if (this.children == null) {
            this.children = new HashMap<String, LevelNode<T>>(2, 0.8f);
        }
    }

    public boolean findAll(String[][] levelValues, int depth, SearchResult<T> result) {
        if (depth >= levelValues.length) {
            result.add((List<T>)this.leafList);
            return true;
        }
        String[] levelVal = levelValues[depth];
        Matcher matcher = this.index.getMatcher(depth);
        Type<ValueHolder> type = this.index.getType(depth);
        MatchMode mode = this.index.getMatchMode(depth);
        boolean union = mode == MatchMode.UNION || mode == MatchMode.UNION_SKIP_DEFAULT;
        boolean[] matchedLevels = new boolean[levelVal.length];
        for (int i = 0; i < levelVal.length; ++i) {
            if (this.children != null) {
                if (matcher == null) {
                    LevelNode<T> child = this.children.get(levelVal[i]);
                    if (child != null) {
                        matchedLevels[i] = child.findAll(levelValues, depth + 1, result);
                        if (matchedLevels[i] && mode != MatchMode.UNION) {
                            matchedLevels[i] = true;
                            continue;
                        }
                    }
                    if (this.defaultNode == null) continue;
                    matchedLevels[i] = this.defaultNode.findAll(levelValues, depth + 1, result);
                    if (!matchedLevels[i] || union) continue;
                    matchedLevels[i] = true;
                    continue;
                }
                for (LevelNode<T> child : this.children.values()) {
                    if (!this.patternMatches(levelVal[i], matcher, type, child.getLevel())) continue;
                    int n = i;
                    matchedLevels[n] = matchedLevels[n] | child.findAll(levelValues, depth + 1, result);
                }
                if (matchedLevels[i] && !union) {
                    matchedLevels[i] = true;
                    continue;
                }
                if (matchedLevels[i] && mode == MatchMode.UNION_SKIP_DEFAULT) {
                    matchedLevels[i] = true;
                    continue;
                }
                if (this.defaultNode == null) continue;
                matchedLevels[i] = this.defaultNode.findAll(levelValues, depth + 1, result);
                if (!matchedLevels[i] || union) continue;
                matchedLevels[i] = true;
                continue;
            }
            if (this.defaultNode == null) continue;
            matchedLevels[i] = this.defaultNode.findAll(levelValues, depth + 1, result);
        }
        return this.isAnyLevelMatched(matchedLevels);
    }

    private boolean isAnyLevelMatched(boolean[] matchedLevels) {
        for (boolean matchedLevel : matchedLevels) {
            if (!matchedLevel) continue;
            return true;
        }
        return false;
    }

    public boolean findAll(String[] levelValues, int depth, SearchResult<T> result) {
        String[][] targetLevelValues = new String[levelValues.length][1];
        for (int i = 0; i < levelValues.length; ++i) {
            targetLevelValues[i] = new String[]{levelValues[i]};
        }
        return this.findAll(targetLevelValues, depth, result);
    }

    private <V extends ValueHolder> boolean patternMatches(String value, Matcher matcher, Type<V> type, String pattern) {
        if (matcher == null) {
            if (pattern == null) {
                return value == null;
            }
            return pattern.equals(value);
        }
        if (matcher.isReverse()) {
            return matcher.matches(pattern, value, type);
        }
        return matcher.matches(value, pattern, type);
    }

    public void trim() {
        if (this.children != null) {
            for (LevelNode<T> child : this.children.values()) {
                child.trim();
            }
        }
        if (this.leafList != null) {
            this.leafList.trimToSize();
        }
    }

    public void printNode(StringBuilder sb, int level) {
        String indent = this.repeat(' ', level << 2);
        boolean leaf = this.isLeaf();
        sb.append(indent).append("path : ").append(this.getLevelPath());
        if (leaf) {
            sb.append("   (leaf=").append(this.leafList).append(')');
        }
        sb.append(Separator.DEFAULT.getValue());
        if (this.children != null) {
            for (LevelNode<T> child : this.children.values()) {
                child.printNode(sb, level + 1);
            }
        }
        if (this.defaultNode != null) {
            this.defaultNode.printNode(sb, level + 1);
        }
    }

    public boolean hasChildren() {
        return this.children != null && !this.children.isEmpty() || this.defaultNode != null;
    }

    public boolean isLeaf() {
        return !this.hasChildren();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LevelNode[");
        sb.append("level=").append(this.level);
        sb.append(", path=").append(this.getLevelPath());
        if (!this.isLeaf()) {
            sb.append(", children=").append(this.children != null ? this.children.keySet() : null);
        } else {
            sb.append(", leaf=").append(this.leafList);
        }
        sb.append(']');
        return sb.toString();
    }

    private String repeat(char c, int count) {
        char[] str = new char[count];
        Arrays.fill(str, c);
        return new String(str);
    }

    private String getLevelPath() {
        String lv = this.level != null ? this.level : "";
        return this.parent != null ? this.parent.getLevelPath() + "/" + lv : lv;
    }

    private String trim(String text) {
        return text != null ? text.trim() : null;
    }

    public String getLevel() {
        return this.level;
    }

    public Map<String, LevelNode<T>> getChildren() {
        return this.children;
    }

    public LevelNode<T> getDefaultNode() {
        return this.defaultNode;
    }

    public ArrayList<T> getLeafList() {
        return this.leafList;
    }

    public LevelNode<T> getParent() {
        return this.parent;
    }
}

