/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.engine.core.output;

import io.higson.runtime.engine.core.output.GettingWrongTypeException;
import io.higson.runtime.engine.core.output.InvalidValueIndexException;
import io.higson.runtime.engine.core.output.UnknownLevelNameException;
import io.higson.runtime.engine.core.type.ValueHolder;
import io.higson.runtime.engine.util.Printer;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;

public class MultiValue {
    private static final int INLINE_TO_STRING_LENGTH = 100;
    private final Object[] values;
    private final Map<String, Integer> indexMap;
    private final String paramName;
    private int last = 0;

    public MultiValue(Object[] values, Map<String, Integer> indexMap, String paramName) {
        this.values = Arrays.copyOf(values, values.length);
        this.indexMap = indexMap;
        this.paramName = paramName;
    }

    public MultiValue(Object[] values, Map<String, Integer> indexMap) {
        this(values, indexMap, null);
    }

    public MultiValue(Object ... values) {
        this(values, null);
    }

    public ValueHolder getHolder(int position) {
        Object obj = this.getAbstractHolder(position);
        if (obj instanceof ValueHolder) {
            return (ValueHolder)obj;
        }
        throw new GettingWrongTypeException(position, "AbstractHolder", obj);
    }

    public <T> T get(int position) {
        return (T)this.getHolder(position).getValue();
    }

    public <T> T get(int position, Class<T> clazz) {
        return clazz.cast(this.getHolder(position).getValue());
    }

    public String getString(int position) {
        return this.getHolder(position).getString();
    }

    public BigDecimal getBigDecimal(int position) {
        return this.getHolder(position).getBigDecimal();
    }

    public Date getDate(int position) {
        return this.getHolder(position).getDate();
    }

    public Date getDatetime(int position) {
        return this.getHolder(position).getDatetime();
    }

    public LocalDate getLocalDate(int position) {
        return this.getHolder(position).getLocalDate();
    }

    public LocalDateTime getLocalDatetime(int position) {
        return this.getHolder(position).getLocalDateTime();
    }

    public Integer getInteger(int position) {
        return this.getHolder(position).getInteger();
    }

    public Boolean getBoolean(int position) {
        return this.getHolder(position).getBoolean();
    }

    public Long getLong(int position) {
        return this.getHolder(position).getLong();
    }

    public ValueHolder getHolder(String name) {
        return this.getHolder(this.index(name));
    }

    public <T> T get(String name) {
        return (T)this.getHolder(this.index(name)).getValue();
    }

    public <T> T get(String name, Class<T> clazz) {
        return clazz.cast(this.getHolder(this.index(name)).getValue());
    }

    public String getString(String name) {
        return this.getString(this.index(name));
    }

    public BigDecimal getBigDecimal(String name) {
        return this.getBigDecimal(this.index(name));
    }

    public Date getDate(String name) {
        return this.getDate(this.index(name));
    }

    public Date getDatetime(String name) {
        return this.getDatetime(this.index(name));
    }

    public LocalDate getLocalDate(String name) {
        return this.getLocalDate(this.index(name));
    }

    public LocalDateTime getLocalDatetime(String name) {
        return this.getLocalDatetime(this.index(name));
    }

    public Integer getInteger(String name) {
        return this.getInteger(this.index(name));
    }

    public Boolean getBoolean(String name) {
        return this.getBoolean(this.index(name));
    }

    public Long getLong(String name) {
        return this.getLong(this.index(name));
    }

    private int index(String name) {
        Integer k;
        if (this.indexMap != null && (k = this.indexMap.get(name)) != null) {
            return k;
        }
        throw new UnknownLevelNameException(name, this.paramName);
    }

    public <T extends Enum<T>> T getEnum(int position, Class<T> enumClass) {
        String code = this.getString(position);
        return code != null ? (T)this.codeToEnum(code, enumClass) : null;
    }

    public <T extends Enum<T>> T getEnum(String name, Class<T> enumClass) {
        return this.getEnum(this.index(name), enumClass);
    }

    private <T extends Enum<T>> T codeToEnum(String code, Class<T> enumClass) {
        try {
            return Enum.valueOf(enumClass, code);
        }
        catch (IllegalArgumentException e) {
            throw new GettingWrongTypeException(e, enumClass, code);
        }
    }

    public ValueHolder[] getArray(int position) {
        Object obj = this.getAbstractHolder(position);
        if (obj instanceof ValueHolder[]) {
            return (ValueHolder[])obj;
        }
        throw new GettingWrongTypeException(position, "AbstractHolder[]", obj);
    }

    public boolean isArray(int position) {
        return this.getAbstractHolder(position) instanceof ValueHolder[];
    }

    public boolean isArray(String name) {
        return this.getAbstractHolder(this.index(name)) instanceof ValueHolder[];
    }

    public Object[] unwrap() {
        Object[] result = new Object[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            ValueHolder[] cell;
            Object val = this.values[i];
            if (val instanceof ValueHolder) {
                cell = (ValueHolder[])val;
                result[i] = cell.getValue();
            }
            if (!(val instanceof ValueHolder[])) continue;
            cell = (ValueHolder[])val;
            Object[] array = new Object[cell.length];
            for (int j = 0; j < cell.length; ++j) {
                array[j] = cell[j].getValue();
            }
            result[i] = array;
        }
        return result;
    }

    public String[] getStringArray(int position) {
        ValueHolder[] array = this.getArray(position);
        String[] result = new String[array.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = array[i].getString();
        }
        return result;
    }

    public Date[] getDateArray(int position) {
        ValueHolder[] array = this.getArray(position);
        Date[] result = new Date[array.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = array[i].getDate();
        }
        return result;
    }

    public LocalDate[] getLocalDateArray(int position) {
        ValueHolder[] array = this.getArray(position);
        LocalDate[] result = new LocalDate[array.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = array[i].getLocalDate();
        }
        return result;
    }

    public LocalDateTime[] getLocalDateTimeArray(int position) {
        ValueHolder[] array = this.getArray(position);
        LocalDateTime[] result = new LocalDateTime[array.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = array[i].getLocalDateTime();
        }
        return result;
    }

    public Integer[] getIntegerArray(int position) {
        ValueHolder[] array = this.getArray(position);
        Integer[] result = new Integer[array.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = array[i].getInteger();
        }
        return result;
    }

    public Long[] getLongArray(int position) {
        ValueHolder[] array = this.getArray(position);
        Long[] result = new Long[array.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = array[i].getLong();
        }
        return result;
    }

    public BigDecimal[] getBigDecimalArray(int position) {
        ValueHolder[] array = this.getArray(position);
        BigDecimal[] result = new BigDecimal[array.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = array[i].getBigDecimal();
        }
        return result;
    }

    public ValueHolder[] getArray(String name) {
        return this.getArray(this.index(name));
    }

    public String[] getStringArray(String name) {
        return this.getStringArray(this.index(name));
    }

    public BigDecimal[] getBigDecimalArray(String name) {
        return this.getBigDecimalArray(this.index(name));
    }

    public Date[] getDateArray(String name) {
        return this.getDateArray(this.index(name));
    }

    public Integer[] getIntegerArray(String name) {
        return this.getIntegerArray(this.index(name));
    }

    public Long[] getLongArray(String name) {
        return this.getLongArray(this.index(name));
    }

    private Object getAbstractHolder(int position) {
        if (position >= 0 && position < this.values.length) {
            return this.values[position];
        }
        throw new InvalidValueIndexException(position, this.values);
    }

    public String[] asStrings() {
        String[] array = new String[this.values.length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.getString(i);
        }
        return array;
    }

    public BigDecimal[] asBigDecimals() {
        BigDecimal[] array = new BigDecimal[this.values.length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.getBigDecimal(i);
        }
        return array;
    }

    public String toString() {
        return Printer.print(this.values, "MultiValue");
    }

    public String toStringInline() {
        Object[] rawValues = this.unwrap();
        StringBuilder sb = new StringBuilder(100);
        sb.append('[');
        for (int i = 0; i < rawValues.length; ++i) {
            Object v;
            if (i > 0) {
                sb.append(", ");
            }
            if ((v = rawValues[i]) instanceof Object[]) {
                sb.append(Arrays.toString((Object[])v));
                continue;
            }
            sb.append(v);
        }
        sb.append(']');
        return sb.toString();
    }

    private int nextPosition() {
        int position = this.last++;
        return position;
    }

    public ValueHolder nextHolder() {
        return this.getHolder(this.nextPosition());
    }

    public <T> T next() {
        return (T)this.nextHolder().getValue();
    }

    public <T> T next(Class<T> clazz) {
        return clazz.cast(this.nextHolder().getValue());
    }

    public String nextString() {
        return this.getString(this.nextPosition());
    }

    public BigDecimal nextBigDecimal() {
        return this.getBigDecimal(this.nextPosition());
    }

    public Date nextDate() {
        return this.getDate(this.nextPosition());
    }

    public LocalDate nextLocalDate() {
        return this.getLocalDate(this.nextPosition());
    }

    public LocalDateTime nextLocalDatetime() {
        return this.getLocalDatetime(this.nextPosition());
    }

    public Integer nextInteger() {
        return this.getInteger(this.nextPosition());
    }

    public Long nextLong() {
        return this.getLong(this.nextPosition());
    }

    public <T extends Enum<T>> T nextEnum(Class<T> enumClass) {
        return this.getEnum(this.nextPosition(), enumClass);
    }

    public ValueHolder[] nextArray() {
        return this.getArray(this.nextPosition());
    }

    public String[] nextStringArray() {
        return this.getStringArray(this.nextPosition());
    }

    public BigDecimal[] nextBigDecimalArray() {
        return this.getBigDecimalArray(this.nextPosition());
    }

    public Date[] nextDateArray() {
        return this.getDateArray(this.nextPosition());
    }

    public LocalDate[] nextLocalDateArray() {
        return this.getLocalDateArray(this.nextPosition());
    }

    public LocalDateTime[] nextLocalDateTimeArray() {
        return this.getLocalDateTimeArray(this.nextPosition());
    }

    public Integer[] nextIntegerArray() {
        return this.getIntegerArray(this.nextPosition());
    }

    public Long[] nextLongArray() {
        return this.getLongArray(this.nextPosition());
    }

    public int size() {
        return this.values != null ? this.values.length : 0;
    }

    public Object[] all() {
        return this.values;
    }

    public boolean isBlank() {
        for (Object cell : this.values) {
            if (this.isBlank(cell)) continue;
            return false;
        }
        return true;
    }

    private boolean isBlank(Object cell) {
        if (cell instanceof ValueHolder) {
            return ((ValueHolder)cell).isBlank();
        }
        return this.isBlank((ValueHolder[])cell);
    }

    private boolean isBlank(ValueHolder[] arr) {
        if (arr == null) {
            return true;
        }
        for (ValueHolder h : arr) {
            if (h.isBlank()) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MultiValue) {
            if (this == obj) {
                return true;
            }
            MultiValue other = (MultiValue)obj;
            return Arrays.deepEquals(this.values, other.values);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.deepHashCode(this.values);
    }
}

