/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.engine.util.reflection;

import io.higson.runtime.engine.util.reflection.ReflectionsHelper;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class PackageFilteringReporter {
    private ClassLoader classLoader;
    private Set<String> cachedWantedPackages = new HashSet<String>();
    private Set<String> wantedPackagesPrefixes;

    public PackageFilteringReporter(ClassLoader classLoader, String[] wantedPackages) {
        this.classLoader = classLoader;
        this.wantedPackagesPrefixes = new HashSet<String>(Arrays.asList(wantedPackages));
    }

    protected Class<?> loadClass(String className) {
        return ReflectionsHelper.loadClass(this.classLoader, className);
    }

    protected boolean isWanted(String packageName) {
        if (this.cachedWantedPackages.contains(packageName)) {
            return true;
        }
        for (String packagePrefix : this.wantedPackagesPrefixes) {
            if (!packageName.startsWith(packagePrefix)) continue;
            this.cachedWantedPackages.add(packageName);
            return true;
        }
        return false;
    }
}

