/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.helper;

import io.higson.runtime.alias.LevelMapper;
import io.higson.runtime.exception.InvalidInputLevelsSizeRuntimeException;
import io.higson.runtime.model.MpParameterEntry;
import io.higson.runtime.model.Parameter;
import io.higson.runtime.model.ParameterLevel;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class MpHelper {
    private static final String HIGHER_LEVEL_SEPARATOR = "#col#";
    private static final Pattern HIGHER_LEVEL_SEPARATOR_PATTERN = Pattern.compile("#col#");
    public static final int MAX_LEVELS = 8;

    public MpParameterEntry createEntry(Parameter p, String ... columns) {
        return this.createEntry(p.getLevelCount(), columns);
    }

    public MpParameterEntry createEntry(int levelCnt, String ... columns) {
        String[] levels = columns;
        int colCnt = columns.length;
        if (levelCnt > colCnt) {
            levels = new String[levelCnt];
            System.arraycopy(columns, 0, levels, 0, colCnt - 1);
            String varCell = columns[colCnt - 1];
            if (varCell != null) {
                String[] varLevel = HIGHER_LEVEL_SEPARATOR_PATTERN.split(varCell, -1);
                int i = colCnt - 1;
                for (int j = 0; i < levelCnt && j < varLevel.length; ++i, ++j) {
                    levels[i] = varLevel[j];
                }
            }
        }
        for (int i = 0; i < levels.length; ++i) {
            levels[i] = this.unify(levels[i]);
        }
        return new MpParameterEntry(levels);
    }

    public MpParameterEntry createEntry(LevelMapper mapper, String ... columns) {
        int sourceLevelCnt = mapper.getMasterLevelCnt();
        MpParameterEntry entry = this.createEntry(sourceLevelCnt, columns);
        entry.applyLevelMapper(mapper);
        return entry;
    }

    public MpParameterEntry createEntry(String ... cells) {
        return new MpParameterEntry(this.normalize(cells));
    }

    public String[] normalize(String ... cells) {
        int cnt = cells.length;
        String lastCell = cells[cnt - 1];
        if (lastCell == null || !lastCell.contains(HIGHER_LEVEL_SEPARATOR)) {
            return cells;
        }
        String[] varLevel = lastCell.split(HIGHER_LEVEL_SEPARATOR, -1);
        String[] all = new String[cnt - 1 + varLevel.length];
        System.arraycopy(cells, 0, all, 0, cnt - 1);
        System.arraycopy(varLevel, 0, all, cnt - 1, varLevel.length);
        return all;
    }

    public String[][] toDatabaseColumns(String[][] logicalCells, int max) {
        if (logicalCells.length < max) {
            return logicalCells;
        }
        String[][] cols = new String[max][];
        for (int i = 0; i < max - 1; ++i) {
            cols[i] = new String[logicalCells[i].length];
            System.arraycopy(logicalCells[i], 0, cols[i], 0, logicalCells[i].length);
        }
        String[] extraLevels = new String[logicalCells.length - max + 1];
        for (int i = max - 1; i < logicalCells.length; ++i) {
            if (logicalCells[i].length != 1) {
                throw new InvalidInputLevelsSizeRuntimeException(i + "th level must contain only 1 value");
            }
            extraLevels[i - (max - 1)] = logicalCells[i][0];
        }
        String strings = StringUtils.join((Object[])Arrays.copyOfRange(extraLevels, 0, extraLevels.length), (String)HIGHER_LEVEL_SEPARATOR) + "#col#%";
        cols[max - 1] = new String[]{strings};
        return cols;
    }

    public String[][] toDatabaseColumns(String[][] logicalCells) {
        return this.toDatabaseColumns(logicalCells, 8);
    }

    public String[] ensureLength(String[] row, int length) {
        if (row.length < length) {
            String[] r = new String[length];
            System.arraycopy(row, 0, r, 0, row.length);
            return r;
        }
        return row;
    }

    public Parameter copyDefinition(Parameter src) {
        Parameter p = new Parameter();
        p.setId(src.getId());
        p.setName(src.getName());
        p.setInputLevels(src.getInputLevels());
        p.setNullable(src.isNullable());
        p.setDictionary(src.isDictionary());
        p.setCacheable(src.isCacheable());
        p.setArraySeparator(src.getArraySeparator());
        p.setSort(src.getSort());
        p.setLastUpdate(src.getLastUpdate());
        for (int i = 0; i < src.getLevelCount(); ++i) {
            ParameterLevel level = src.getLevel(i);
            p.addLevel(level.copy());
        }
        p.setEntriesCount(src.getEntries().size());
        p.setMid(src.getMid());
        p.setSlave(src.isSlave());
        p.setMasterName(src.getMasterName());
        p.setDistinct(src.isDistinct());
        p.setDigest(src.getDigest());
        p.setExternalSource(src.isExternalSource());
        p.setExternalInMemQuery(src.getExternalInMemQuery());
        p.setExternalNonMemQuery(src.getExternalNonMemQuery());
        p.setExternalDataSource(src.getExternalDataSource());
        p.setAutoRefresh(src.isAutoRefresh());
        p.setAutoRefreshPeriod(src.getAutoRefreshPeriod());
        p.setLoadedAt(src.getLoadedAt());
        p.postprocess();
        return p;
    }

    public String createInListPattern(int n) {
        return StringUtils.repeat((String)"?", (String)",", (int)n);
    }

    public String unify(String str) {
        return StringUtils.isBlank((CharSequence)str) ? null : str;
    }
}

