/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.invoker;

import java.util.Optional;

public class GroovyPreprocessor {
    private String standardFunctions = this.getStandardFunctions();

    public String preprocess(String body) {
        return Optional.ofNullable(body).map(String::trim).orElse("") + this.standardFunctions;
    }

    private String getStandardFunctions() {
        StringBuilder stdFun = new StringBuilder();
        this.appendLine(stdFun, "//#std::begin");
        this.appendStdFunction(stdFun, "_integer", "type.getInteger");
        this.appendStdFunction(stdFun, "_number", "type.getNumber");
        this.appendStdFunction(stdFun, "_decimal", "type.getDecimal");
        this.appendStdFunction(stdFun, "_boolean", "type.getBoolean");
        this.appendStdFunction(stdFun, "_string", "type.getString");
        this.appendStdFunction(stdFun, "_date", "type.getDate");
        this.appendStdFunction(stdFun, "_datetime", "type.getDatetime");
        this.add1ArgFunctions(stdFun);
        this.add2ArgFunctions(stdFun);
        this.appendLine(stdFun, "//#std::end");
        return stdFun.toString();
    }

    private void add2ArgFunctions(StringBuilder stdFun) {
        this.appendStdFunction2arg(stdFun, "_num", "type.getNumber");
        this.appendStdFunction2arg(stdFun, "_dec", "type.getDecimal");
    }

    private void add1ArgFunctions(StringBuilder stdFun) {
        this.appendStdFunction(stdFun, "_int", "_integer");
        this.appendStdFunction(stdFun, "_num", "_number");
        this.appendStdFunction(stdFun, "_dec", "_decimal");
        this.appendStdFunction(stdFun, "_bool", "_boolean");
        this.appendStdFunction(stdFun, "_str", "_string");
    }

    private void appendStdFunction(StringBuilder sb, String f1, String f2) {
        this.appendLine(sb, String.format("def %s(x){return %s(x)}", f1, f2));
    }

    private void appendStdFunction2arg(StringBuilder sb, String f1, String f2) {
        this.appendLine(sb, String.format("def %s(x,y){return %s(x,y)}", f1, f2));
    }

    private void appendLine(StringBuilder sb, String line) {
        sb.append(line).append('\n');
    }
}

