/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.profiler.jdbc.proxy;

import io.higson.runtime.profiler.jdbc.proxy.PreparedStatementProxy;
import io.higson.runtime.profiler.jdbc.proxy.StatementProxy;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;

public class ConnectionProxy
implements InvocationHandler {
    private static final Class<?>[] INTERFACES = new Class[]{Connection.class};
    private Connection conn;

    public ConnectionProxy(Connection conn) {
        this.conn = conn;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if ("prepareStatement".equals(method.getName())) {
            String sql = (String)args[0];
            PreparedStatement ps = (PreparedStatement)method.invoke((Object)this.conn, args);
            return PreparedStatementProxy.newInstance(sql, ps);
        }
        if ("createStatement".equals(method.getName())) {
            Statement stmt = (Statement)method.invoke((Object)this.conn, args);
            return StatementProxy.newInstance(stmt);
        }
        return method.invoke((Object)this.conn, args);
    }

    public static Connection newInstance(Connection conn) {
        return (Connection)Proxy.newProxyInstance(conn.getClass().getClassLoader(), INTERFACES, (InvocationHandler)new ConnectionProxy(conn));
    }
}

