/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.rhino.domain;

import io.higson.runtime.core.EmptyParamValue;
import io.higson.runtime.core.HigsonContext;
import io.higson.runtime.engine.core.output.ParamValue;
import io.higson.runtime.engine.core.type.ValueHolder;
import io.higson.runtime.helper.TypeConverter;
import io.higson.runtime.model.DomainAttribute;
import io.higson.runtime.rhino.value.RhinoEmptyValue;
import io.higson.runtime.rhino.value.RhinoParamValue;
import java.math.BigDecimal;
import java.util.Date;

public class RhinoDomainAttribute {
    private static final HigsonContext EMPTY_CTX = new HigsonContext(new Object[0]);
    private static final EmptyParamValue EMPTY_PV = new EmptyParamValue();
    private static final RhinoEmptyValue EMPTY_RPV = new RhinoEmptyValue();
    private static final TypeConverter type = TypeConverter.getInstance();
    private final DomainAttribute attr;
    private final HigsonContext ctx;

    public RhinoDomainAttribute(DomainAttribute attr, HigsonContext ctx) {
        this.attr = attr;
        this.ctx = this.notnull(ctx);
    }

    public RhinoParamValue getValue(HigsonContext ctx) {
        ParamValue pv = this.getParamValue(ctx);
        return pv != null ? new RhinoParamValue(pv) : EMPTY_RPV;
    }

    public RhinoParamValue getValue() {
        return this.getValue(this.ctx);
    }

    public String getString(HigsonContext ctx) {
        return type.getString(this.value(ctx));
    }

    public String getString() {
        return this.getString(this.ctx);
    }

    public double getNumber(HigsonContext ctx) {
        return type.getNumber(this.value(ctx));
    }

    public double getNumber() {
        return this.getNumber(this.ctx);
    }

    public BigDecimal getDecimal(HigsonContext ctx) {
        return type.getDecimal(this.value(ctx));
    }

    public BigDecimal getDecimal() {
        return this.getDecimal(this.ctx);
    }

    public Integer getInteger(HigsonContext ctx) {
        return type.getInteger(this.value(ctx));
    }

    public Integer getInteger() {
        return this.getInteger(this.ctx);
    }

    public Date getDate(HigsonContext ctx) {
        return type.getDate(this.value(ctx));
    }

    public Date getDate() {
        return this.getDate(this.ctx);
    }

    public boolean getBoolean(HigsonContext ctx) {
        return type.getBoolean(this.value(ctx));
    }

    public boolean getBoolean() {
        return this.getBoolean(this.ctx);
    }

    public Object value(HigsonContext ctx) {
        ValueHolder holder = this.getParamValue(ctx).getHolder();
        return holder != null ? holder.getValue() : null;
    }

    public ParamValue getParamValue(HigsonContext ctx) {
        return this.attr != null ? this.attr.getValue(ctx, new Object[0]) : EMPTY_PV;
    }

    public ParamValue getParamValue() {
        return this.getParamValue(this.ctx);
    }

    public String getDigest() {
        return this.attr != null ? this.attr.getDigest() : null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RhinoDomainAttribute[");
        if (this.attr != null) {
            sb.append(this.attr.getCode()).append('=').append(this.attr.getRawValue());
        }
        sb.append(']');
        return sb.toString();
    }

    private HigsonContext notnull(HigsonContext ctx) {
        return ctx != null ? ctx : EMPTY_CTX;
    }
}

