/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.utils;

import io.higson.runtime.engine.types.date.SimpleDateFormatPool;
import io.higson.runtime.exception.HigsonRuntimeException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;

public abstract class HprDate {
    public static final String YMD = "yyyy-MM-dd";
    public static final String YMDHMS = "yyyy-MM-dd HH:mm:ss";
    public static final String YMDHMSMS = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final Pattern DMY_MINUS_PATTERN = Pattern.compile("\\d{2}-\\d{2}-\\d{4}");
    private static final Pattern DMY_DOT_PATTERN = Pattern.compile("\\d{2}\\.\\d{2}\\.\\d{4}");
    private static final Pattern DMY_SLASH_PATTERN = Pattern.compile("\\d{2}/\\d{2}/\\d{4}");
    private static final Pattern YMD_MINUS_PATTERN = Pattern.compile("\\d{4}-\\d{2}-\\d{2}");
    private static final Pattern YMD_DOT_PATTERN = Pattern.compile("\\d{4}\\.\\d{2}\\.\\d{2}");
    private static final Pattern YMD_SLASH_PATTERN = Pattern.compile("\\d{4}/\\d{2}/\\d{2}");
    public static final String DMY = "dd-MM-yyyy";

    private HprDate() {
        throw new UnsupportedOperationException("util class");
    }

    public static String format(Date d) {
        return HprDate.format(d, YMD);
    }

    public static String formatTimestamp(Date d) {
        return HprDate.format(d, YMDHMSMS);
    }

    public static String formatTimestamp(long timestamp) {
        return HprDate.formatTimestamp(new Date(timestamp));
    }

    public static String format(Date d, String pattern) {
        return d != null ? HprDate.getSimpleDateFormat(pattern).format(d) : null;
    }

    public static SimpleDateFormat getSimpleDateFormat(String pattern) {
        return SimpleDateFormatPool.get(pattern);
    }

    public static Date parse(String text) {
        return HprDate.guess(text);
    }

    public static Date guess(String text) {
        String dateStr = text.trim();
        if (dateStr.length() == 10) {
            char c2;
            char c1 = dateStr.charAt(2);
            if (HprDate.bothEqualTo(c1, c2 = dateStr.charAt(5), '-')) {
                return HprDate.parse(dateStr, DMY);
            }
            if (HprDate.bothEqualTo(c1, c2, '.')) {
                return HprDate.parse(dateStr, "dd.MM.yyyy");
            }
            if (HprDate.bothEqualTo(c1, c2, '/')) {
                return HprDate.parse(dateStr, "dd/MM/yyyy");
            }
            c1 = dateStr.charAt(4);
            if (HprDate.bothEqualTo(c1, c2 = dateStr.charAt(7), '-')) {
                return HprDate.parse(dateStr, YMD);
            }
            if (HprDate.bothEqualTo(c1, c2, '.')) {
                return HprDate.parse(dateStr, "yyyy.MM.dd");
            }
            if (HprDate.bothEqualTo(c1, c2, '/')) {
                return HprDate.parse(dateStr, "yyyy/MM/dd");
            }
        }
        throw new IllegalArgumentException("Unknown date format: [" + dateStr + "]");
    }

    public static boolean canDecode(String text) {
        String dateStr = text.trim();
        if (dateStr.length() == 10) {
            char c2;
            char c1 = dateStr.charAt(2);
            if (HprDate.bothEqualTo(c1, c2 = dateStr.charAt(5), '-')) {
                return DMY_MINUS_PATTERN.matcher(dateStr).matches();
            }
            if (HprDate.bothEqualTo(c1, c2, '.')) {
                return DMY_DOT_PATTERN.matcher(dateStr).matches();
            }
            if (HprDate.bothEqualTo(c1, c2, '/')) {
                return DMY_SLASH_PATTERN.matcher(dateStr).matches();
            }
            c1 = dateStr.charAt(4);
            if (HprDate.bothEqualTo(c1, c2 = dateStr.charAt(7), '-')) {
                return YMD_MINUS_PATTERN.matcher(dateStr).matches();
            }
            if (HprDate.bothEqualTo(c1, c2, '.')) {
                return YMD_DOT_PATTERN.matcher(dateStr).matches();
            }
            if (HprDate.bothEqualTo(c1, c2, '/')) {
                return YMD_SLASH_PATTERN.matcher(dateStr).matches();
            }
        }
        return false;
    }

    public static int parseTime(String text) {
        int h = 0;
        int m = 0;
        int s = 0;
        int ms = 0;
        int state = 1;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == ':' || c == '.' || c == ',' || c == ' ') {
                ++state;
                continue;
            }
            int d = c - 48;
            if (state == 1) {
                h = h * 10 + d;
                continue;
            }
            if (state == 2) {
                m = m * 10 + d;
                continue;
            }
            if (state == 3) {
                s = s * 10 + d;
                continue;
            }
            if (state != 4) continue;
            ms = ms * 10 + d;
        }
        if (state > 4 || h > 23 || m > 59 || s > 59 || ms > 999) {
            throw new HigsonRuntimeException("Illegal time format: " + text);
        }
        return (h * 3600 + m * 60 + s) * 1000 + ms;
    }

    public static boolean canDecodeTime(String text) {
        int h = 0;
        int m = 0;
        int s = 0;
        int ms = 0;
        int state = 1;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == ':' || c == '.' || c == ',' || c == ' ') {
                ++state;
                continue;
            }
            int d = c - 48;
            if (state == 1) {
                h = h * 10 + d;
                continue;
            }
            if (state == 2) {
                m = m * 10 + d;
                continue;
            }
            if (state == 3) {
                s = s * 10 + d;
                continue;
            }
            if (state != 4) continue;
            ms = ms * 10 + d;
        }
        return state <= 4 && h <= 23 && m <= 59 && s <= 59 && ms <= 999;
    }

    private static boolean bothEqualTo(char c1, char c2, char expected) {
        return c1 == expected && c2 == expected;
    }

    public static Date parse(String dateStr, String pattern) {
        try {
            return SimpleDateFormatPool.get(pattern).parse(dateStr);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Cannot parse date string [" + dateStr + "]", e);
        }
    }
}

