/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.engine.types.datetime;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import org.smartparam.engine.annotated.annotations.ParamType;
import org.smartparam.engine.core.type.Type;
import org.smartparam.engine.types.datetime.AbstractDateTimeType;
import org.smartparam.engine.types.datetime.DatetimeHolder;
import org.smartparam.engine.util.EngineUtil;

@ParamType(value="datetime")
public class DatetimeType
extends AbstractDateTimeType<Date>
implements Type<DatetimeHolder> {
    @Override
    public String encode(DatetimeHolder holder) {
        return holder.getString();
    }

    @Override
    public DatetimeHolder decode(String text) {
        Date date = EngineUtil.hasText(text) ? (Date)this.guess(text) : null;
        return new DatetimeHolder(date);
    }

    @Override
    public DatetimeHolder convert(Object obj) {
        if (obj instanceof Date) {
            return new DatetimeHolder((Date)obj);
        }
        if (obj instanceof LocalDateTime) {
            return new DatetimeHolder(Date.from(((LocalDateTime)obj).atZone(ZoneId.systemDefault()).toInstant()));
        }
        if (obj instanceof LocalDate) {
            return new DatetimeHolder(Date.from(((LocalDate)obj).atStartOfDay(ZoneId.systemDefault()).toInstant()));
        }
        if (obj instanceof Calendar) {
            Calendar cal = (Calendar)obj;
            return new DatetimeHolder(cal.getTime());
        }
        if (obj == null) {
            return new DatetimeHolder(null);
        }
        if (obj instanceof String) {
            return this.decode((String)obj);
        }
        throw new IllegalArgumentException("conversion not supported for: " + obj.getClass());
    }

    public DatetimeHolder[] newArray(int size) {
        return new DatetimeHolder[size];
    }

    @Override
    protected Date parseLong(String input) {
        return new Date(Long.parseLong(input));
    }

    @Override
    protected Date of(long date) {
        return new Date(date);
    }
}

