/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.dev;

import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartparam.engine.core.UnknownParameterException;
import org.smartparam.engine.core.function.UnknownFunctionException;
import pl.decerto.hyperon.runtime.core.versioninterceptor.RuntimeVersionInterceptor;
import pl.decerto.hyperon.runtime.dev.DevModeProvider;
import pl.decerto.hyperon.runtime.dev.RegionInfo;
import pl.decerto.hyperon.runtime.dev.perspective.RuntimeSession;
import pl.decerto.hyperon.runtime.dev.perspective.RuntimeSessionElement;
import pl.decerto.hyperon.runtime.model.ElementType;
import pl.decerto.hyperon.runtime.model.RegionVersion;

public class DevModePerspective {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final DevModeProvider devModeProvider;
    private final RuntimeVersionInterceptor runtimeInterceptor;
    private final ElementDescriptor parameterDescriptor = new ParameterDescriptor();
    private final ElementDescriptor functionDescriptor = new FunctionDescriptor();

    public DevModePerspective(DevModeProvider devModeProvider, RuntimeVersionInterceptor runtimeInterceptor) {
        this.devModeProvider = devModeProvider;
        this.runtimeInterceptor = runtimeInterceptor;
    }

    private String decorateElementName(String code, String user, ElementDescriptor descriptor) {
        this.log.trace("creating uid, par/fun={}, user={}", (Object)code, (Object)user);
        if (code.contains(":") || code.contains("@")) {
            return code;
        }
        ElementType type = descriptor.getElementType();
        RegionVersion ver = this.discoverVersion(code, user, type);
        RuntimeSession session = this.devModeProvider.getSession(user);
        if (session != null) {
            return this.decorateElement(code, descriptor, type, ver, session).orElseGet(() -> this.uid(code, ver));
        }
        return this.uid(code, ver);
    }

    private Optional<String> decorateElement(String code, ElementDescriptor descriptor, ElementType type, RegionVersion ver, RuntimeSession session) {
        for (RuntimeSessionElement e : session.findElements(code)) {
            if (e.getElementType() != type || !this.sameVersion(ver, e.getRegionVersionId())) continue;
            if (e.isCreateOrUpdate()) {
                return Optional.of(this.uid(code, ver, session.getId()));
            }
            if (!e.isDelete()) continue;
            descriptor.raiseUnknownElementException(code, session);
        }
        return Optional.empty();
    }

    private RegionVersion discoverVersion(String code, String user, ElementType type) {
        return this.devModeProvider.getRegionForElement(code, user, type).map(regionInfo -> this.findVersion(code, user, type, (RegionInfo)regionInfo)).orElse(null);
    }

    private RegionVersion findVersion(String code, String user, ElementType type, RegionInfo regionInfo) {
        this.log.trace("found regionInfo: {}", (Object)regionInfo);
        RegionVersion version = this.runtimeInterceptor.getEffectiveVersion(code, regionInfo.getProfile(), regionInfo.getRegionCode(), type).map(ver -> this.devModeProvider.getVersion(regionInfo.getRegionCode(), (String)ver)).orElse(null);
        this.log.trace("found preset version: {}", (Object)version);
        if (Objects.isNull(version)) {
            version = this.devModeProvider.getUserVersion(user, regionInfo.getRegionCode());
            this.log.trace("found user version: {}", (Object)version);
        }
        if (Objects.isNull(version)) {
            version = this.devModeProvider.getActiveVersion(regionInfo.getRegionCode());
            this.log.trace("found active version: {}", (Object)version);
        }
        return version;
    }

    private String uid(String code, RegionVersion ver, int sid) {
        return code + this.uidVer(ver) + ":" + sid;
    }

    private String uid(String code, RegionVersion ver) {
        return code + this.uidVer(ver);
    }

    private String uidVer(RegionVersion ver) {
        return ver != null ? "@" + ver.getNumber() : "";
    }

    public String decorateParameterName(String code, String user) {
        return this.decorateElementName(code, user, this.parameterDescriptor);
    }

    public String decorateFunctionName(String code, String user) {
        return this.decorateElementName(code, user, this.functionDescriptor);
    }

    private boolean sameVersion(RegionVersion ver, int rvid) {
        return ver == null ? rvid == 0 : rvid == ver.getId();
    }

    private class ParameterDescriptor
    implements ElementDescriptor {
        private ParameterDescriptor() {
        }

        @Override
        public ElementType getElementType() {
            return ElementType.PARAMETER;
        }

        @Override
        public void raiseUnknownElementException(String code, RuntimeSession session) {
            DevModePerspective.this.log.warn("parameter {} found but marked to delete in runtime session: {}", (Object)code, (Object)session);
            throw new UnknownParameterException(code + " (found but marked to delete in session " + session.getId() + ")");
        }
    }

    private static interface ElementDescriptor {
        public ElementType getElementType();

        public void raiseUnknownElementException(String var1, RuntimeSession var2);
    }

    private class FunctionDescriptor
    implements ElementDescriptor {
        private FunctionDescriptor() {
        }

        @Override
        public ElementType getElementType() {
            return ElementType.FUNCTION;
        }

        @Override
        public void raiseUnknownElementException(String code, RuntimeSession session) {
            DevModePerspective.this.log.warn("function {} found but marked to delete in runtime session: {}", (Object)code, (Object)session);
            throw new UnknownFunctionException(code + " (found but marked to delete in session " + session.getId() + ")");
        }
    }
}

