/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.function.log;

import org.slf4j.Logger;
import org.slf4j.event.Level;
import pl.decerto.hyperon.runtime.function.log.FunctionLogLevel;
import pl.decerto.hyperon.runtime.function.log.FunctionLogLevelResolver;
import pl.decerto.hyperon.runtime.function.log.HyperonLogger;
import pl.decerto.hyperon.runtime.model.Function;

final class FunctionLogger
implements HyperonLogger {
    private final Logger logger;
    private final Function function;
    private final FunctionLogLevelResolver functionLogLevelResolver;

    FunctionLogger(Logger logger, Function function, FunctionLogLevelResolver functionLogLevelResolver) {
        this.logger = logger;
        this.function = function;
        this.functionLogLevelResolver = functionLogLevelResolver;
    }

    public String getName() {
        return this.logger.getName();
    }

    @Override
    public boolean isTrace() {
        FunctionLogLevel functionFinalLogLevel = this.functionLogLevelResolver.getFunctionFinalLogLevel(this.function);
        return functionFinalLogLevel.getLevels().contains(Level.TRACE);
    }

    @Override
    public void trace(String format, Object ... arguments) {
        if (this.isTrace()) {
            this.logger.trace(format, arguments);
        }
    }

    @Override
    public boolean isDebug() {
        FunctionLogLevel functionFinalLogLevel = this.functionLogLevelResolver.getFunctionFinalLogLevel(this.function);
        return functionFinalLogLevel.getLevels().contains(Level.DEBUG);
    }

    @Override
    public void debug(String format, Object ... arguments) {
        if (this.isDebug()) {
            this.logger.debug(format, arguments);
        }
    }

    @Override
    public boolean isInfo() {
        FunctionLogLevel functionFinalLogLevel = this.functionLogLevelResolver.getFunctionFinalLogLevel(this.function);
        return functionFinalLogLevel.getLevels().contains(Level.INFO);
    }

    @Override
    public void info(String format, Object ... arguments) {
        if (this.isInfo()) {
            this.logger.info(format, arguments);
        }
    }

    @Override
    public boolean isWarn() {
        FunctionLogLevel functionFinalLogLevel = this.functionLogLevelResolver.getFunctionFinalLogLevel(this.function);
        return functionFinalLogLevel.getLevels().contains(Level.WARN);
    }

    @Override
    public void warn(String format, Object ... arguments) {
        if (this.isWarn()) {
            this.logger.warn(format, arguments);
        }
    }

    @Override
    public boolean isError() {
        FunctionLogLevel functionFinalLogLevel = this.functionLogLevelResolver.getFunctionFinalLogLevel(this.function);
        return functionFinalLogLevel.getLevels().contains(Level.ERROR);
    }

    @Override
    public void error(String format, Object ... arguments) {
        if (this.isError()) {
            this.logger.error(format, arguments);
        }
    }
}

