/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.rhino;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.helpers.MessageFormatter;
import org.smartparam.engine.annotated.annotations.FetchSuggestion;
import org.smartparam.engine.util.EngineUtil;
import org.smartparam.engine.util.Printer;
import pl.decerto.hyperon.runtime.helper.StrUtil;
import pl.decerto.hyperon.runtime.utils.HprString;

public class RhinoStr
extends StringUtils {
    public static final RhinoStr INSTANCE = new RhinoStr();
    public static final int CONCAT_INITIAL_CAPACITY = 32;
    private static final int N3 = 3;

    private RhinoStr() {
    }

    @FetchSuggestion(value="suggester.str.compactSpaces")
    public static String compactSpaces(String s) {
        return StrUtil.compactSpaces(s);
    }

    @FetchSuggestion(value="suggester.str.filterDigits")
    public static String filterDigits(String s) {
        return RhinoStr.filterChars(s, '0', '9');
    }

    @FetchSuggestion(value="suggester.str.filterChars_str_char_char")
    public static String filterChars(String s, char lower, char upper) {
        char c;
        int i;
        if (s == null) {
            return null;
        }
        int len = s.length();
        for (i = 0; i < len && (c = s.charAt(i)) >= lower && c <= upper; ++i) {
        }
        if (i == len) {
            return s;
        }
        StringBuilder sb = new StringBuilder(len - 1);
        for (i = 0; i < len; ++i) {
            c = s.charAt(i);
            if (c < lower || c > upper) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    @FetchSuggestion(value="suggester.str.filterChars_str_str")
    public static String filterChars(String s, String allowed) {
        int i;
        if (s == null || allowed == null) {
            return null;
        }
        int len = s.length();
        for (i = 0; i < len && allowed.indexOf(s.charAt(i)) >= 0; ++i) {
        }
        if (i == len) {
            return s;
        }
        StringBuilder sb = new StringBuilder(len - 1);
        for (i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (allowed.indexOf(c) < 0) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    @FetchSuggestion(value="suggester.str.rejectChars")
    public static String rejectChars(String s, String rejected) {
        int i;
        if (s == null || rejected == null) {
            return s;
        }
        int len = s.length();
        for (i = 0; i < len && rejected.indexOf(s.charAt(i)) < 0; ++i) {
        }
        if (i == len) {
            return s;
        }
        StringBuilder sb = new StringBuilder(len - 1);
        for (i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (rejected.indexOf(c) >= 0) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    @FetchSuggestion(value="suggester.str.capitalizeFirst")
    public static String capitalizeFirst(String text) {
        if (text != null && text.length() > 0) {
            return text.substring(0, 1).toUpperCase() + text.substring(1);
        }
        return text;
    }

    @FetchSuggestion(value="suggester.str.capitalizeAll")
    public static String capitalizeAll(String str) {
        String[] words;
        if (str == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (String word : words = str.replaceAll("\\s+", " ").trim().split(" ")) {
            builder.append(RhinoStr.capitalizeFirst(word)).append(' ');
        }
        return builder.toString().trim();
    }

    @FetchSuggestion(value="suggester.str.concat_objArr")
    public static String concat(Object[] arr) {
        return RhinoStr.concat(arr, ",");
    }

    @FetchSuggestion(value="suggester.str.concat_objArr_str")
    public static String concat(Object[] arr, String delim) {
        return RhinoStr.concat(arr, delim, "null");
    }

    @FetchSuggestion(value="suggester.str.concat_objArr_str_str")
    public static String concat(Object[] arr, String delim, String nullReplacement) {
        if (arr == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(32);
        boolean first = true;
        for (Object e : arr) {
            if (first) {
                first = false;
            } else {
                sb.append(delim);
            }
            sb.append(RhinoStr.format(e, nullReplacement));
        }
        return sb.toString();
    }

    private static String format(Object obj, String nullReplacement) {
        return obj != null ? obj.toString() : nullReplacement;
    }

    @FetchSuggestion(value="suggester.str.concat_List_str")
    public static String concat(List<?> list, String delim) {
        return list != null ? RhinoStr.concat(list.toArray(), delim) : "";
    }

    @FetchSuggestion(value="suggester.str.concat_List")
    public static String concat(List<?> list) {
        return RhinoStr.concat(list, ",");
    }

    @FetchSuggestion(value="suggester.str.getCommonStart")
    public static String getCommonStart(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return null;
        }
        if (s1.equals(s2)) {
            return s1;
        }
        int maxSize = Math.min(s1.length(), s2.length());
        StringBuilder sb = new StringBuilder(maxSize);
        for (int i = 0; i < maxSize && s1.charAt(i) == s2.charAt(i); ++i) {
            sb.append(s1.charAt(i));
        }
        return sb.toString();
    }

    @FetchSuggestion(value="suggester.str.padLeft_str_num")
    public static String padLeft(String s, int len) {
        return HprString.alignLeft(s, len);
    }

    @FetchSuggestion(value="suggester.str.padLeft_str_char_num")
    public static String padLeft(String s, char c, int len) {
        return HprString.alignLeft(s, c, len);
    }

    @FetchSuggestion(value="suggester.str.padRight_str_num")
    public static String padRight(String s, int len) {
        return HprString.alignRight(s, len);
    }

    @FetchSuggestion(value="suggester.str.padRight_str_char_num")
    public static String padRight(String s, char c, int len) {
        return HprString.alignRight(s, c, len);
    }

    @FetchSuggestion(value="suggester.str.notNull")
    public static String notNull(String str) {
        return str != null ? str : "";
    }

    @FetchSuggestion(value="suggester.str.trim")
    public static String trim(String s) {
        return s != null ? s.trim() : null;
    }

    @FetchSuggestion(value="suggester.str.print_obj_str_number")
    public static String print(Object list, String title, int maxLines) {
        List<Object> coll = null;
        if (list instanceof Collection) {
            coll = (List<Object>)list;
        } else if (list instanceof Object[]) {
            coll = Arrays.asList((Object[])list);
        } else if (list instanceof Iterable) {
            coll = new ArrayList<Object>();
            for (Object o : (Iterable)list) {
                coll.add(o);
            }
        }
        if (coll != null) {
            return Printer.print(coll, title, maxLines, null);
        }
        return null;
    }

    @FetchSuggestion(value="suggester.str.print_obj_str")
    public static String print(Object list, String title) {
        return RhinoStr.print(list, title, 0);
    }

    @FetchSuggestion(value="suggester.str.print_obj")
    public static String print(Object list) {
        return RhinoStr.print(list, "");
    }

    @FetchSuggestion(value="suggester.str.len")
    public static int len(String str) {
        return str != null ? str.length() : 0;
    }

    @FetchSuggestion(value="suggester.str.count")
    public static int count(String s, char c) {
        int count = 0;
        if (s != null) {
            for (int i = 0; i < s.length(); ++i) {
                if (s.charAt(i) != c) continue;
                ++count;
            }
        }
        return count;
    }

    @FetchSuggestion(value="suggester.str.repeat")
    public static String repeat(char c, int count) {
        StringBuilder sb = new StringBuilder(count);
        for (int i = 0; i < count; ++i) {
            sb.append(c);
        }
        return sb.toString();
    }

    @FetchSuggestion(value="suggester.str.contains_coll_str")
    public static boolean contains(Collection<?> coll, String fragment) {
        String f = fragment.toLowerCase();
        if (coll != null) {
            for (Object obj : coll) {
                if (!String.valueOf(obj).toLowerCase().contains(f)) continue;
                return true;
            }
        }
        return false;
    }

    @FetchSuggestion(value="suggester.str.contains_strArr_str")
    public static boolean contains(String[] arr, String element) {
        if (arr != null) {
            for (String str : arr) {
                if (!str.equals(element)) continue;
                return true;
            }
        }
        return false;
    }

    @FetchSuggestion(value="suggester.str.split_str_char")
    public static String[] split(String str, char delim) {
        return EngineUtil.split(str, delim);
    }

    @FetchSuggestion(value="suggester.str.split_str_char_num")
    public static String[] split(String str, char delim, int max) {
        return EngineUtil.split(str, delim, max);
    }

    @FetchSuggestion(value="suggester.str.trunc")
    public static String trunc(String s, int maxlen) {
        return s.length() <= maxlen ? s : s.substring(0, maxlen - 3) + "...";
    }

    @FetchSuggestion(value="suggester.str.nvl")
    public static String nvl(String val) {
        return val == null ? "" : val;
    }

    @FetchSuggestion(value="suggester.str.format")
    public static String format(String pattern, Object ... args) {
        return MessageFormatter.arrayFormat((String)pattern, (Object[])args).getMessage();
    }
}

