/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.sync;

import java.time.Duration;

public class WatcherConfig {
    public static final int DEFAULT_START_DELAY_SECONDS = 10;
    public static final int DEFAULT_WATCHER_PAUSE_SECONDS = 3;
    public static final int DEFAULT_ERROR_RECOVERY_SECONDS = 30;
    public static final int DEFAULT_FORCE_SYNC_SECONDS = 60;
    private int startDelaySeconds;
    private int watcherPauseSeconds;
    private int errorPauseSeconds;
    private int forcePauseSeconds;

    public WatcherConfig(int startDelaySeconds, int watcherPauseSeconds, int errorPauseSeconds, int forcePauseSeconds) {
        this.startDelaySeconds = startDelaySeconds;
        this.watcherPauseSeconds = watcherPauseSeconds;
        this.errorPauseSeconds = errorPauseSeconds;
        this.forcePauseSeconds = forcePauseSeconds;
    }

    public WatcherConfig(int startDelaySeconds, int watcherPauseSeconds, int errorPauseSeconds) {
        this(startDelaySeconds, watcherPauseSeconds, errorPauseSeconds, 60);
    }

    public WatcherConfig(int watcherPauseSeconds) {
        this(10, watcherPauseSeconds, 30);
    }

    public WatcherConfig() {
        this(3);
    }

    public WatcherConfig delay(int startDelaySeconds) {
        this.startDelaySeconds = startDelaySeconds;
        return this;
    }

    public WatcherConfig pause(int pauseSeconds) {
        this.watcherPauseSeconds = pauseSeconds;
        return this;
    }

    public WatcherConfig error(int errorSeconds) {
        this.errorPauseSeconds = errorSeconds;
        return this;
    }

    public WatcherConfig force(int forceSeconds) {
        this.forcePauseSeconds = forceSeconds;
        return this;
    }

    public int getStartDelaySeconds() {
        return this.startDelaySeconds;
    }

    public int getWatcherPauseSeconds() {
        return this.watcherPauseSeconds;
    }

    public int getErrorPauseSeconds() {
        return this.errorPauseSeconds;
    }

    public int getForcePauseSeconds() {
        return this.forcePauseSeconds;
    }

    public long getForcePauseMillis() {
        return Duration.ofSeconds(this.forcePauseSeconds).toMillis();
    }

    public String toString() {
        return String.format("delay: %ds, pause: %ds, error: %ds, force: %ds", this.startDelaySeconds, this.watcherPauseSeconds, this.errorPauseSeconds, this.forcePauseSeconds);
    }
}

